/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.api.groundspeak.ui.FieldNoteOptionsHelper;
import geocentral.common.Messages;
import geocentral.common.actions.AppContext;
import geocentral.common.app.UserProfile;
import geocentral.common.data.DataModelUtils;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.files.FileReaderService;
import geocentral.common.data.files.ReadFileArgs;
import geocentral.common.fieldnotes.FieldNoteDedupRule1;
import geocentral.common.fieldnotes.FieldNoteDedupRule2;
import geocentral.common.fieldnotes.FieldNoteDedupRule3;
import geocentral.common.fieldnotes.FieldNoteDedupRule4;
import geocentral.common.fieldnotes.FieldNoteDeduplicator;
import geocentral.common.fieldnotes.FieldNoteItemLogDateComparator;
import geocentral.common.fieldnotes.FieldNotesDateUtils;
import geocentral.common.fieldnotes.GpxImportDataStore;
import geocentral.common.fieldnotes.IFieldNoteDedupRule;
import geocentral.common.files.FieldNoteReader;
import geocentral.common.plugins.AppContextService;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.preferences.PreferenceStoreManager;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public final class FieldNoteImportUtils {
    public static void importFieldNotes(List<FieldNoteItem> fieldNotes, String[] files) {
        AssertUtils.notNull(fieldNotes, "Field Notes");
        AssertUtils.notNull(files, "Files");
        LinkedList<FieldNoteItem> items = new LinkedList<FieldNoteItem>();
        fieldNotes.clear();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            try {
                FieldNoteReader reader = new FieldNoteReader(true, FieldNotesDateUtils.createDateParser());
                reader.readFile(filename);
                for (FieldNoteItem item : reader.getItems()) {
                    if (item == null || item.getGeocacheCode() == null) continue;
                    items.add(item);
                }
            }
            catch (IOException | ParseException e) {
                DialogUtils.showError(String.format("%s: %s%n%n%s", Messages.getString("FieldNoteImportUtils.fileImportError"), filename, e.getMessage()));
            }
            ++n2;
        }
        Collections.sort(items, new FieldNoteItemLogDateComparator());
        fieldNotes.addAll(items);
        FieldNoteImportUtils.deduplicateFieldNotes(fieldNotes);
        FieldNoteImportUtils.handleOptions(items);
    }

    public static void importGPX(UserProfile profile, List<FieldNoteItem> fieldNotes, String[] files) {
        AssertUtils.notNull(profile, "User Profile");
        AssertUtils.notNull(fieldNotes, "Field Notes");
        AssertUtils.notNull(files, "Files");
        fieldNotes.clear();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            GpxImportDataStore store = new GpxImportDataStore(profile, fieldNotes);
            AppContext appContext = AppContextService.getInstance().createAppContext(null);
            DataModelUtils.setDataStore(appContext, store);
            ReadFileArgs args = new ReadFileArgs(filename);
            FileReaderService.getInstance().readAction(args, appContext);
            ++n2;
        }
    }

    public static void deduplicateFieldNotes(List<FieldNoteItem> fieldNotes) {
        IFieldNoteDedupRule[] rules;
        AssertUtils.notNull(fieldNotes, "Field Notes");
        FieldNoteDeduplicator dedup = new FieldNoteDeduplicator(fieldNotes);
        IFieldNoteDedupRule[] iFieldNoteDedupRuleArray = rules = new IFieldNoteDedupRule[]{new FieldNoteDedupRule1(), new FieldNoteDedupRule2(), new FieldNoteDedupRule3(), new FieldNoteDedupRule4()};
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IFieldNoteDedupRule rule = iFieldNoteDedupRuleArray[n2];
            int dups = dedup.deduplicate(rule);
            if (dups > 0) {
                DialogUtils.showInfo(String.format("%s%n%n%s: %s.%n%s: %d", Messages.getString("FieldNoteImportUtils.duplicatesRemoved"), Messages.getString("FieldNoteImportUtils.rule"), StringUtils.nvl(rule.getRuleName(), Messages.getString("FieldNoteImportUtils.noRuleName")), Messages.getString("FieldNoteImportUtils.duplicates"), dups));
            }
            ++n2;
        }
    }

    public static void handleOptions(List<FieldNoteItem> fieldNotes) {
        AssertUtils.notNull(fieldNotes, "Field Notes");
        boolean visitByDefault = PreferenceStoreManager.getStore().getBoolean("geocentral.preferences.fieldnotes.visit_on_import");
        if (visitByDefault) {
            FieldNoteOptionsHelper helper = new FieldNoteOptionsHelper();
            helper.onVisit(fieldNotes, true);
        }
    }
}

