/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.fieldnotes.FieldNoteItemLogDateComparator;
import geocentral.common.fieldnotes.IFieldNoteDedupRule;
import geocentral.common.geocaching.GeocacheLogType;
import java.util.Collections;
import java.util.List;
import org.bacza.utils.EnumUtils;
import org.bacza.utils.StringUtils;

public class FieldNoteDedupRule4
implements IFieldNoteDedupRule {
    private static final FieldNoteItemLogDateComparator comparator = new FieldNoteItemLogDateComparator();
    private static final GeocacheLogType[] logTypes = new GeocacheLogType[]{GeocacheLogType.NEEDS_MAINT, GeocacheLogType.NEEDS_ARCH};

    @Override
    public String getRuleName() {
        return String.format(Messages.getString("FieldNoteDedupRule4.ruleName"), new Object[]{logTypes[0], logTypes[1]});
    }

    @Override
    public String getKey(FieldNoteItem item) {
        String code = StringUtils.nvl(item.getGeocacheCode(), item.getGuid());
        String logType = EnumUtils.getName(item.getLogType());
        if (StringUtils.notEmpty(code, logType)) {
            return String.format("%s-%s", code, logType);
        }
        return null;
    }

    @Override
    public boolean checkLogType(GeocacheLogType logType) {
        return EnumUtils.equalsAny(logType, logTypes);
    }

    @Override
    public void deduplicate(List<FieldNoteItem> items) {
        if (items.size() > 1) {
            Collections.sort(items, comparator);
            FieldNoteItem last = items.get(items.size() - 1);
            items.clear();
            items.add(last);
        }
    }
}

