/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteItemIterator;
import geocentral.common.fieldnotes.FieldNoteCheckerConfig;
import geocentral.common.fieldnotes.FieldNoteCheckerDialog;
import geocentral.common.fieldnotes.IFieldNoteCheckRule;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.ui.DisplayUtils;
import java.util.List;
import org.bacza.utils.AssertUtils;

public class FieldNoteChecker {
    private final FieldNoteItemIterator iter;
    private final FieldNoteCheckerConfig config;

    public FieldNoteChecker(FieldNoteItemIterator iter) {
        AssertUtils.notNull(iter, "Item Iterator");
        this.iter = iter;
        this.config = FieldNoteCheckerConfig.getInstance();
    }

    public boolean check() {
        for (GeocacheSite site : this.iter.getAllSites()) {
            if (this.check(site)) continue;
            return false;
        }
        return true;
    }

    public boolean check(GeocacheSite site) {
        AssertUtils.notNull((Object)site, "Site");
        FieldNoteItemIterator siteIter = new FieldNoteItemIterator(this.iter, site);
        for (IFieldNoteCheckRule rule : this.config.getRules(site)) {
            siteIter.reset();
            List<FieldNoteItem> items = rule.check(siteIter);
            if (items == null || items.size() <= 0) continue;
            if (rule.isBlocking()) {
                this.showMessage(rule, items);
                return false;
            }
            if (this.showMessage(rule, items)) continue;
            return false;
        }
        return true;
    }

    private boolean showMessage(IFieldNoteCheckRule rule, List<FieldNoteItem> items) {
        FieldNoteCheckerDialog dialog = new FieldNoteCheckerDialog(DisplayUtils.getShell(), rule, items);
        int result = dialog.open();
        return result == 0;
    }
}

