/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.ItemIterator;
import geocentral.common.fieldnotes.IFieldNoteCheckRule;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.api.GeocachingApiService;
import geocentral.common.geocaching.api.LogOptions;
import java.util.LinkedList;
import java.util.List;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class FieldNoteCheckRule4
implements IFieldNoteCheckRule {
    private static final int DEFAULT_LOG_LENGTH = 4000;
    private static final int SIG_LENGTH = 100;
    private final GeocacheSite site;
    private final int max;

    public FieldNoteCheckRule4(GeocacheSite site) {
        AssertUtils.notNull((Object)site, "Site");
        this.site = site;
        LogOptions opts = GeocachingApiService.getInstance().getLogOptions(site);
        this.max = opts != null && opts.maxLength > 0 ? Math.max(0, opts.maxLength - 100) : Math.max(0, 3900);
    }

    @Override
    public String getRuleName() {
        return String.format(Messages.getString("FieldNoteCheckRule4.name"), this.site.getSiteName());
    }

    @Override
    public String getRuleComment() {
        return String.format(Messages.getString("FieldNoteCheckRule4.comment"), this.max);
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public List<FieldNoteItem> check(ItemIterator<FieldNoteItem> iter) {
        LinkedList<FieldNoteItem> result = new LinkedList<FieldNoteItem>();
        while (iter.hasNext()) {
            String logText;
            FieldNoteItem item = iter.next();
            if (!iter.isSelected() || StringUtils.length(logText = StringUtils.trim(item.getLogText())) <= this.max) continue;
            result.add(item);
        }
        return result;
    }
}

