/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.fieldnotes;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.ItemIterator;
import geocentral.common.fieldnotes.IFieldNoteCheckRule;
import geocentral.common.geocaching.GeocacheLogType;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bacza.utils.DateUtils;
import org.bacza.utils.EnumUtils;

public class FieldNoteCheckRule2
implements IFieldNoteCheckRule {
    private static final GeocacheLogType[] logTypes = new GeocacheLogType[]{GeocacheLogType.NEEDS_MAINT, GeocacheLogType.NEEDS_ARCH};

    @Override
    public String getRuleName() {
        return String.format(Messages.getString("FieldNoteCheckRule2.name"), new Object[]{logTypes[0], logTypes[1]});
    }

    @Override
    public String getRuleComment() {
        return Messages.getString("FieldNoteCheckRule2.comment");
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public List<FieldNoteItem> check(ItemIterator<FieldNoteItem> iter) {
        LinkedList<FieldNoteItem> result = new LinkedList<FieldNoteItem>();
        Date today = DateUtils.truncate(new Date());
        while (iter.hasNext()) {
            Date logDate;
            FieldNoteItem item = iter.next();
            if (!iter.isSelected() || !EnumUtils.equalsAny(item.getLogType(), logTypes) || today.equals(logDate = DateUtils.truncate(item.getLogDate()))) continue;
            result.add(item);
        }
        return result;
    }
}

