/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data.parsers;

import geocentral.common.data.parsers.IUserParser;
import geocentral.common.data.parsers.ParserException;
import geocentral.common.data.parsers.XmlParserImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.bacza.utils.IOUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    public static void parse(String data, IUserParser parser) throws ParserException {
        if (data == null || parser == null) {
            throw new ParserException("Invalid parameters.");
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes("UTF-8"));
            XmlParser.parse(is, parser);
        }
        catch (UnsupportedEncodingException e) {
            throw new ParserException(e);
        }
    }

    public static void parse(InputStream data, IUserParser parser) throws ParserException {
        if (data == null || parser == null) {
            throw new ParserException("Invalid parameters.");
        }
        try {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(data, (DefaultHandler)new XmlParserImpl(parser));
            }
            catch (ParserConfigurationException e) {
                throw new ParserException(e);
            }
            catch (SAXException e) {
                throw new ParserException(e);
            }
            catch (IOException e) {
                throw new ParserException(e);
            }
        }
        finally {
            IOUtils.close(data);
        }
    }
}

