/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data.parsers;

import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.IParserContext;
import geocentral.common.data.parsers.IUserParser;
import java.io.IOException;
import java.util.Stack;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.ParseException;

public class JsonParserImpl
implements ContentHandler,
IParserContext {
    private static final IAttributes EMPTY_ATTRS = new IAttributes(){

        @Override
        public int getAttributeCount() {
            return 0;
        }

        @Override
        public String getAttributeValue(String attrName) {
            return null;
        }
    };
    private Stack<ParserState> parsers = new Stack();
    private ParserState currentParser = new ParserState(null);
    private ParserState nextParser = null;
    private boolean continueParsing = true;
    private int skip = 0;

    public JsonParserImpl() {
    }

    public JsonParserImpl(IUserParser userParser) {
        this();
        this.installParser(userParser);
    }

    @Override
    public void installParser(IUserParser parser) throws IllegalArgumentException {
        if (parser == null) {
            throw new IllegalArgumentException("NULL parser.");
        }
        this.nextParser = new ParserState(parser);
    }

    @Override
    public void abort() {
        this.continueParsing = false;
    }

    private void setToken(ParserToken token) {
        this.currentParser.lastToken = this.currentParser.currentToken;
        this.currentParser.currentToken = token;
    }

    private void startSubElementImpl() {
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        if (this.nextParser == null) {
            this.skip = 1;
            if (this.currentParser.currentToken == ParserToken.START_OBJECT && (this.currentParser.lastToken == ParserToken.START_ARRAY || this.currentParser.lastToken == ParserToken.END_OBJECT)) {
                this.skip = 0;
            }
            return;
        }
        this.nextParser.initToken(this.currentParser);
        this.nextParser.userParser.setParserContext(this);
        this.parsers.push(this.currentParser);
        this.currentParser = this.nextParser;
        this.nextParser = null;
        this.skip = 0;
    }

    private void endSubElementImpl() throws IllegalStateException {
        if (this.skip > 0) {
            --this.skip;
        }
        if (this.currentParser.nestedObjects <= 0 && this.currentParser.nestedArrays <= 0) {
            if (this.parsers.size() == 0) {
                throw new IllegalStateException("NULL parser.");
            }
            this.currentParser = this.parsers.pop();
            this.skip = 0;
        }
    }

    public void startJSON() throws ParseException, IOException {
    }

    public void endJSON() throws ParseException, IOException, IllegalStateException {
        if (this.continueParsing && this.parsers.size() > 0) {
            throw new IllegalStateException("Invalid JSON document.");
        }
    }

    public boolean startObject() throws ParseException, IOException, IllegalStateException {
        this.setToken(ParserToken.START_OBJECT);
        this.startSubElementImpl();
        ParserState parserState = this.currentParser;
        parserState.nestedObjects = parserState.nestedObjects + 1;
        if (this.skip == 0) {
            this.currentParser.userParser.startProcessing();
        }
        return this.continueParsing;
    }

    public boolean endObject() throws ParseException, IOException, IllegalStateException {
        this.setToken(ParserToken.END_OBJECT);
        if (this.skip == 0) {
            this.currentParser.userParser.stopProcessing();
        }
        ParserState parserState = this.currentParser;
        parserState.nestedObjects = parserState.nestedObjects - 1;
        this.endSubElementImpl();
        return this.continueParsing;
    }

    public boolean startObjectEntry(String arg0) throws ParseException, IOException, IllegalStateException {
        this.setToken(ParserToken.START_OBJECT_ENTRY);
        if (this.skip == 0) {
            this.currentParser.names.push(arg0);
            this.currentParser.userParser.startElement(arg0);
        }
        return this.continueParsing;
    }

    public boolean endObjectEntry() throws ParseException, IOException, IllegalStateException {
        this.setToken(ParserToken.END_OBJECT_ENTRY);
        if (this.skip == 0) {
            this.currentParser.userParser.endElement((String)this.currentParser.names.pop());
        }
        return this.continueParsing;
    }

    public boolean startArray() throws ParseException, IOException, IllegalStateException {
        this.setToken(ParserToken.START_ARRAY);
        this.startSubElementImpl();
        ParserState parserState = this.currentParser;
        parserState.nestedArrays = parserState.nestedArrays + 1;
        return this.continueParsing;
    }

    public boolean endArray() throws ParseException, IOException, IllegalStateException {
        this.setToken(ParserToken.END_ARRAY);
        ParserState parserState = this.currentParser;
        parserState.nestedArrays = parserState.nestedArrays - 1;
        this.endSubElementImpl();
        return this.continueParsing;
    }

    public boolean primitive(Object arg0) throws ParseException, IOException, IllegalStateException {
        this.setToken(ParserToken.VALUE);
        if (this.skip == 0) {
            if (this.currentParser.names.size() == 0) {
                this.currentParser.userParser.value(arg0);
            } else {
                this.currentParser.userParser.value((String)this.currentParser.names.peek(), arg0, EMPTY_ATTRS);
            }
        }
        return this.continueParsing;
    }

    @Override
    public IAttributes getCurrentElementAttrs() {
        return EMPTY_ATTRS;
    }

    private class ParserState {
        private IUserParser userParser;
        private ParserToken currentToken;
        private ParserToken lastToken;
        private int nestedObjects;
        private int nestedArrays;
        private Stack<String> names;

        ParserState(IUserParser userParser) {
            this.userParser = userParser;
            this.currentToken = ParserToken.NONE;
            this.lastToken = ParserToken.NONE;
            this.nestedObjects = 0;
            this.nestedArrays = 0;
            this.names = new Stack();
        }

        private void initToken(ParserState currentParser) {
            if (currentParser != null) {
                this.currentToken = currentParser.currentToken;
            }
        }
    }

    private static enum ParserToken {
        NONE,
        START_OBJECT,
        END_OBJECT,
        START_OBJECT_ENTRY,
        END_OBJECT_ENTRY,
        START_ARRAY,
        END_ARRAY,
        VALUE;

    }
}

