/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data.files;

import geocentral.common.actions.IActionContext;
import geocentral.common.data.DataModelUtils;
import geocentral.common.data.DataReaderContext;
import geocentral.common.data.files.IFileReaderAsyncPlugin;
import geocentral.common.data.files.ReadFileArgs;
import geocentral.common.data.parsers.GenericParser;
import geocentral.common.data.parsers.IUserParser;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.data.parsers.XmlParser;
import java.io.FileInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.IOUtils;

public abstract class GenericFileReaderPlugin
implements IFileReaderAsyncPlugin {
    private static final Log log = LogFactory.getLog(GenericFileReaderPlugin.class);

    @Override
    public void readFile(IActionContext ctx, ReadFileArgs args) {
        block7: {
            String msg = String.format("Reading file: %s...", args.getFilename());
            log.debug((Object)msg);
            ctx.beginTask(msg);
            DataReaderContext readerContext = new DataReaderContext(ctx, DataModelUtils.getDataStore(ctx));
            FileInputStream is = null;
            try {
                try {
                    GenericParser parser = new GenericParser(readerContext);
                    is = new FileInputStream(args.getFilename());
                    XmlParser.parse(is, (IUserParser)parser);
                    UserParser rootParser = parser.getRootParser();
                    if (rootParser == null) {
                        log.debug((Object)"File format not supported.");
                    } else {
                        int size = readerContext.getDataStore().getCounter();
                        log.debug((Object)String.format("%s: items loaded: %d", rootParser.getClass().getName(), size));
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"Exception", (Throwable)e);
                    IOUtils.close(is);
                    readerContext.getDataStore().flush();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                readerContext.getDataStore().flush();
                throw throwable;
            }
            IOUtils.close(is);
            readerContext.getDataStore().flush();
        }
        ctx.done();
    }
}

