/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.ItemIterator;
import geocentral.common.geocaching.GeocacheSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldNoteItemIterator
extends ItemIterator<FieldNoteItem> {
    protected final Set<GeocacheSite> allSites = new HashSet<GeocacheSite>();
    protected final Set<GeocacheSite> selectedSites = new HashSet<GeocacheSite>();

    public FieldNoteItemIterator(List<FieldNoteItem> allItems, List<FieldNoteItem> selectedItems) {
        super(allItems, selectedItems);
        this.initSiteSet(allItems, this.allSites);
        this.initSiteSet(selectedItems, this.selectedSites);
    }

    public FieldNoteItemIterator(FieldNoteItemIterator iterator) {
        this(iterator, null);
    }

    public FieldNoteItemIterator(FieldNoteItemIterator iterator, GeocacheSite site) {
        this(FieldNoteItemIterator.filterItems(iterator != null ? iterator.allItems : null, site), FieldNoteItemIterator.filterItems(iterator != null ? iterator.selectedItems : null, site));
    }

    private static List<FieldNoteItem> filterItems(List<FieldNoteItem> items, GeocacheSite site) {
        if (items != null && site != null) {
            ArrayList<FieldNoteItem> filtered = new ArrayList<FieldNoteItem>(items.size());
            for (FieldNoteItem item : items) {
                if (item == null || !site.equals((Object)item.getSite())) continue;
                filtered.add(item);
            }
            return filtered;
        }
        return items;
    }

    protected void initSiteSet(List<FieldNoteItem> items, Set<GeocacheSite> sites) {
        for (FieldNoteItem item : items) {
            GeocacheSite site = item.getSite();
            if (site == null) continue;
            sites.add(site);
        }
    }

    public Set<GeocacheSite> getAllSites() {
        return Collections.unmodifiableSet(this.allSites);
    }

    public Set<GeocacheSite> getSelectedSites() {
        return Collections.unmodifiableSet(this.selectedSites);
    }
}

