/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.data;

import geocentral.common.data.FieldNoteStatus;
import geocentral.common.data.FieldNoteType;
import geocentral.common.data.IChangeEventSource;
import geocentral.common.data.IDataItem;
import geocentral.common.geocaching.GeocacheCodeService;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.GeocacheSize;
import geocentral.common.geocaching.GeocacheType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.util.Date;
import org.bacza.utils.DateUtils;
import org.bacza.utils.EnumUtils;
import org.bacza.utils.ObjectUtils;
import org.eclipse.swt.graphics.Image;

public class FieldNoteItem
implements IChangeEventSource,
IDataItem {
    private static final long serialVersionUID = 4905019088857292692L;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private FieldNoteType fieldNoteType = FieldNoteType.UNKNOWN;
    private FieldNoteStatus fieldNoteStatus = FieldNoteStatus.UNKNOWN;
    private GeocacheSite site = GeocacheSite.UNKNOWN;
    private String refCode;
    private String geocacheCode;
    private String geocacheName;
    private String geocacheOwner;
    private String guid;
    private GeocacheType type;
    private GeocacheSize size;
    private Double ratingDifficulty;
    private Double ratingTerrain;
    private Double lat;
    private Double lon;
    private Integer favPoints;
    private String hint;
    private Date logDate;
    private GeocacheLogType logType;
    private Date existingLogDate;
    private GeocacheLogType existingLogType;
    private boolean existingLogChecked;
    private String logText;
    private String logTextFormatted;
    private URI newLogLink;
    private URI composeLink;
    private URI deleteLink;
    private boolean favourite;
    private boolean visitTrackables;
    private Image image;
    private String tag;
    private Double rating;
    private Integer ratingVotes;
    private boolean passwordRequired;
    private Double optRating;
    private String optPassword;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    @Override
    public void notifyChange() {
        this.support.firePropertyChange("this", 0, 1);
    }

    public FieldNoteType getFieldNoteType() {
        return this.fieldNoteType;
    }

    public void setFieldNoteType(FieldNoteType fieldNoteType) {
        this.fieldNoteType = fieldNoteType;
    }

    public FieldNoteStatus getFieldNoteStatus() {
        return this.fieldNoteStatus;
    }

    public void setFieldNoteStatus(FieldNoteStatus fieldNoteStatus) {
        this.fieldNoteStatus = fieldNoteStatus;
    }

    @Override
    public String getItemId() {
        return this.geocacheCode;
    }

    public GeocacheSite getSite() {
        return this.site;
    }

    public void setSite(GeocacheSite site) {
        this.site = site != null ? site : GeocacheSite.UNKNOWN;
    }

    public String getRefCode() {
        return this.refCode;
    }

    public void setRefCode(String refCode) {
        this.refCode = refCode;
    }

    public String getGeocacheCode() {
        return this.geocacheCode;
    }

    public void setGeocacheCode(String geocacheCode) {
        this.geocacheCode = geocacheCode;
        if (this.site == null || this.site.equals((Object)GeocacheSite.UNKNOWN)) {
            this.setSite(GeocacheCodeService.getInstance().getSite(geocacheCode));
        }
    }

    public String getGeocacheName() {
        return this.geocacheName;
    }

    public void setGeocacheName(String geocacheName) {
        this.geocacheName = geocacheName;
    }

    public String getGeocacheOwner() {
        return this.geocacheOwner;
    }

    public void setGeocacheOwner(String geocacheOwner) {
        this.geocacheOwner = geocacheOwner;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public GeocacheType getType() {
        return this.type;
    }

    public void setType(GeocacheType type) {
        this.type = type;
    }

    public GeocacheSize getSize() {
        return this.size;
    }

    public void setSize(GeocacheSize size) {
        this.size = size;
    }

    public Double getRatingDifficulty() {
        return this.ratingDifficulty;
    }

    public void setRatingDifficulty(Double ratingDifficulty) {
        this.ratingDifficulty = ratingDifficulty;
    }

    public Double getRatingTerrain() {
        return this.ratingTerrain;
    }

    public void setRatingTerrain(Double ratingTerrain) {
        this.ratingTerrain = ratingTerrain;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Integer getFavPoints() {
        return this.favPoints;
    }

    public void setFavPoints(Integer favPoints) {
        this.favPoints = favPoints;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    public GeocacheLogType getLogType() {
        return this.logType;
    }

    public void setLogType(GeocacheLogType logType) {
        this.logType = logType;
    }

    public Date getExistingLogDate() {
        return this.existingLogDate;
    }

    public void setExistingLogDate(Date existingLogDate) {
        this.existingLogDate = existingLogDate;
    }

    public GeocacheLogType getExistingLogType() {
        return this.existingLogType;
    }

    public void setExistingLogType(GeocacheLogType existingLogType) {
        this.existingLogType = existingLogType;
    }

    public boolean isExistingLogChecked() {
        return this.existingLogChecked;
    }

    public void setExistingLogChecked(boolean existingLogChecked) {
        this.existingLogChecked = existingLogChecked;
    }

    public String getLogText() {
        return this.logText;
    }

    public void setLogText(String logText) {
        this.logText = logText;
    }

    public String getLogTextFormatted() {
        return this.logTextFormatted;
    }

    public void setLogTextFormatted(String logTextFormatted) {
        this.logTextFormatted = logTextFormatted;
    }

    public URI getNewLogLink() {
        return this.newLogLink;
    }

    public void setNewLogLink(URI newLogLink) {
        this.newLogLink = newLogLink;
    }

    public URI getComposeLink() {
        return this.composeLink;
    }

    public void setComposeLink(URI composeLink) {
        this.composeLink = composeLink;
    }

    public URI getDeleteLink() {
        return this.deleteLink;
    }

    public void setDeleteLink(URI deleteLink) {
        this.deleteLink = deleteLink;
    }

    public boolean getFavourite() {
        return this.favourite;
    }

    public void setFavourite(boolean favourite) {
        this.favourite = favourite;
    }

    public boolean getVisitTrackables() {
        return this.visitTrackables;
    }

    public void setVisitTrackables(boolean visitTrackables) {
        this.visitTrackables = visitTrackables;
    }

    public int getOptions() {
        return (this.getFavourite() ? 1 : 0) + (this.getVisitTrackables() ? 2 : 0);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String toString() {
        return String.format("[code=%s, type=%s, date=%s]", new Object[]{this.geocacheCode, this.logType, this.logDate});
    }

    public void updateFieldNoteStatus() {
        if (!this.isExistingLogChecked()) {
            this.setFieldNoteStatus(FieldNoteStatus.UNKNOWN);
            return;
        }
        FieldNoteStatus status = FieldNoteStatus.NEW;
        if (this.existingLogType != null) {
            boolean willattend;
            boolean found = EnumUtils.equalsAny(this.existingLogType, GeocacheLogType.FOUND_IT, GeocacheLogType.WEBCAM_PHOTO_TAKEN);
            boolean dnf = this.existingLogType == GeocacheLogType.DNF;
            boolean attended = this.existingLogType == GeocacheLogType.ATTENDED;
            boolean bl = willattend = this.existingLogType == GeocacheLogType.WILL_ATTEND;
            if (found) {
                if (EnumUtils.equalsAny(this.logType, GeocacheLogType.FOUND_IT, GeocacheLogType.DNF, GeocacheLogType.WEBCAM_PHOTO_TAKEN)) {
                    status = FieldNoteStatus.DUPLICATE;
                }
            } else if (dnf) {
                Date d2;
                Date d1;
                if (this.logType == GeocacheLogType.DNF && ObjectUtils.equals(d1 = DateUtils.truncate(this.logDate), d2 = DateUtils.truncate(this.existingLogDate))) {
                    status = FieldNoteStatus.DUPLICATE;
                }
            } else if (attended) {
                if (EnumUtils.equalsAny(this.logType, GeocacheLogType.FOUND_IT, GeocacheLogType.ATTENDED, GeocacheLogType.WILL_ATTEND)) {
                    status = FieldNoteStatus.DUPLICATE;
                }
            } else if (willattend && this.logType == GeocacheLogType.WILL_ATTEND) {
                status = FieldNoteStatus.DUPLICATE;
            }
        }
        this.setFieldNoteStatus(status);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Double getRating() {
        return this.rating;
    }

    public void setRating(Double rating) {
        this.rating = rating;
    }

    public Integer getRatingVotes() {
        return this.ratingVotes;
    }

    public void setRatingVotes(Integer ratingVotes) {
        this.ratingVotes = ratingVotes;
    }

    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public void setPasswordRequired(boolean passwordRequired) {
        this.passwordRequired = passwordRequired;
    }

    public Double getOptRating() {
        return this.optRating;
    }

    public void setOptRating(Double optRating) {
        this.optRating = optRating;
    }

    public String getOptPassword() {
        return this.optPassword;
    }

    public void setOptPassword(String optPassword) {
        this.optPassword = optPassword;
    }
}

