/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.UserProfileService;
import geocentral.common.data.IChangeEventSource;
import geocentral.http.WebClientManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.http.WebClient;
import org.bacza.http.WebSocket;
import org.bacza.http.WebSocketEventListener;
import org.bacza.http.WebSocketStatusListener;
import org.bacza.utils.IOUtils;
import org.bacza.utils.StringUtils;
import org.json.JSONObject;

public final class WebConnectService
implements IChangeEventSource {
    private static final Log log = LogFactory.getLog(WebConnectService.class);
    private static final URI API_URI = URI.create("https://www.geocentral.pl");
    private static final String API_BIND_PATH = "/api/connect";
    private static final int API_VERSION = 1;
    private static final WebConnectService instance = new WebConnectService();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final String appId = UserProfileService.getInstance().getAppId();
    private final String sessionId = UUID.randomUUID().toString();
    private final WebSocket socket;
    private final WebConnectListener listener;
    private final SystemMessageListener systemListener;
    private final Map<String, JSONObject> systemMessages;
    private boolean connected;
    private boolean authenticated;

    public static WebConnectService getInstance() {
        return instance;
    }

    private WebConnectService() {
        WebClient client = WebClientManager.getInstance().getSystemClient();
        this.socket = new WebSocket(client, API_URI, API_BIND_PATH);
        this.listener = new WebConnectListener();
        this.socket.addStatusListener(this.listener);
        this.socket.addEventListener("authenticated", this.listener);
        this.socket.addEventListener("unauthorized", this.listener);
        this.systemListener = new SystemMessageListener();
        this.socket.addEventListener("system_message", this.systemListener);
        this.systemMessages = new HashMap<String, JSONObject>();
        this.connected = false;
        this.authenticated = false;
        this.socket.open();
    }

    public synchronized boolean isReady() {
        return this.connected && this.authenticated;
    }

    public synchronized boolean waitForConnection() {
        return this.waitForConnection(0L);
    }

    public synchronized boolean waitForConnection(long msec) {
        while (!this.isReady()) {
            try {
                this.wait(msec);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return this.isReady();
    }

    void send(String event, Object ... args) {
        this.socket.send(event, args);
    }

    public void shutdown() {
        IOUtils.close(this.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getSystemMessage(String type) {
        Map<String, JSONObject> map = this.systemMessages;
        synchronized (map) {
            if (StringUtils.notEmpty(type)) {
                return this.systemMessages.get(type);
            }
            return null;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void notifyChange() {
        this.notifyChange("*");
    }

    private void notifyChange(String id) {
        this.changeSupport.firePropertyChange(id, 0, 1);
    }

    private class SystemMessageListener
    implements WebSocketEventListener {
        public static final String EVENT_SYSTEM_MSG = "system_message";

        private SystemMessageListener() {
        }

        @Override
        public void event(String event, Object ... args) {
            if (args != null && args.length >= 1 && args[0] instanceof JSONObject) {
                this.onSystemMessage((JSONObject)args[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onSystemMessage(JSONObject msg) {
            String type = msg.optString("type", null);
            if (StringUtils.notEmpty(type)) {
                Map map = WebConnectService.this.systemMessages;
                synchronized (map) {
                    JSONObject payload = msg.optJSONObject("payload");
                    WebConnectService.this.systemMessages.put(type, payload != null ? payload : msg);
                }
                WebConnectService.this.notifyChange(type);
            }
        }
    }

    private class WebConnectListener
    implements Serializable,
    WebSocketStatusListener,
    WebSocketEventListener {
        private static final long serialVersionUID = 4832514410694880601L;
        public static final String EVENT_AUTHENTICATED = "authenticated";
        public static final String EVENT_UNAUTHORIZED = "unauthorized";

        private WebConnectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connected() {
            WebConnectService webConnectService = WebConnectService.this;
            synchronized (webConnectService) {
                WebConnectService.this.connected = true;
                WebConnectService.this.authenticated = false;
            }
            WebConnectService.this.socket.send("authentication", new JSONObject().put("token", (Object)new StringBuilder(String.valueOf(4832514410694880601L)).reverse().toString()).put("version", 1).put("appid", (Object)WebConnectService.this.appId).put("sid", (Object)WebConnectService.this.sessionId));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnected() {
            WebConnectService webConnectService = WebConnectService.this;
            synchronized (webConnectService) {
                WebConnectService.this.connected = false;
                WebConnectService.this.authenticated = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void event(String event, Object ... args) {
            boolean authResponse;
            boolean bl = authResponse = EVENT_AUTHENTICATED.equals(event) || EVENT_UNAUTHORIZED.equals(event);
            if (authResponse) {
                boolean authOK = EVENT_AUTHENTICATED.equals(event);
                log.trace((Object)(authOK ? "Service READY!" : "Service ERROR!"));
                WebConnectService webConnectService = WebConnectService.this;
                synchronized (webConnectService) {
                    WebConnectService.this.authenticated = authOK;
                    if (authOK) {
                        WebConnectService.this.notifyAll();
                    }
                }
            }
        }
    }
}

