/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bacza.utils.StringUtils;

public final class VersionUtils {
    private static final Pattern VER_STD = Pattern.compile("^(\\d+)\\.(\\d+)(\\.(\\d+))?$");
    private static final Pattern VER_RC = Pattern.compile("^(\\d+)\\.(\\d+)-rc(\\d+)$", 2);

    public static long getVersionNumber(int major, int minor, int patch) {
        return (long)patch + (long)minor * 1000L + (long)major * 1000000L;
    }

    public static long getVersionNumberRC(int major, int minor, int rc) {
        return VersionUtils.getVersionNumber(major, minor, 0) - 100L + (long)rc;
    }

    public static long parse(String version) {
        try {
            if (StringUtils.notEmpty(version)) {
                Matcher m1 = VER_STD.matcher(version);
                if (m1.find()) {
                    return VersionUtils.getVersionNumber(VersionUtils.parseInt(m1.group(1)), VersionUtils.parseInt(m1.group(2)), VersionUtils.parseInt(m1.group(4)));
                }
                Matcher m2 = VER_RC.matcher(version);
                if (m2.find()) {
                    return VersionUtils.getVersionNumberRC(VersionUtils.parseInt(m2.group(1)), VersionUtils.parseInt(m2.group(2)), VersionUtils.parseInt(m2.group(3)));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0L;
    }

    private static int parseInt(String str) {
        if (StringUtils.notEmpty(str)) {
            return Integer.parseInt(str);
        }
        return 0;
    }
}

