/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.ConfigDataService;
import geocentral.common.app.IConfigData;
import geocentral.common.app.SiteProfile;
import geocentral.common.app.StorageService;
import geocentral.common.app.UsageServiceUtils;
import geocentral.common.app.UserProfile;
import geocentral.common.app.UserProfileException;
import geocentral.common.app.UserProfileListener;
import geocentral.common.geocaching.GeocacheSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.json.JSONUtils;
import org.bacza.events.EventSource;
import org.bacza.events.ListenerList;
import org.bacza.http.URLUtils;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.EnumUtils;
import org.bacza.utils.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public final class UserProfileService
implements EventSource<UserProfileListener> {
    private static final Log log = LogFactory.getLog(UserProfileService.class);
    private static final String FILE_NAME = "system-data-0.dat";
    private static final String DEFAULT_UUID = "00000001-0001-0001-0001-000000000001";
    private static final UserProfile DEFAULT_PROFILE = new UserProfile("00000001-0001-0001-0001-000000000001", "default");
    private static final UserProfileService instance = new UserProfileService();
    private final IConfigData data = ConfigDataService.getInstance().getSystemData("system-data-0.dat", true);
    private final ListenerList<UserProfileListener> listenerList = new ListenerList();
    private final UserProfiles userProfiles = new UserProfiles();
    private String appId;
    private UserProfile currentProfile;
    private UserProfile lastProfile;

    public static UserProfileService getInstance() {
        return instance;
    }

    private UserProfileService() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        IConfigData iConfigData = this.data;
        synchronized (iConfigData) {
            this.appId = null;
            this.currentProfile = DEFAULT_PROFILE;
            this.userProfiles.clear();
            JSONObject root = this.data.getObject("config");
            this.appId = root.optString("appId", null);
            JSONArray array = root.optJSONArray("userProfiles");
            int max = array != null ? array.length() : 0;
            int i = 0;
            while (i < max) {
                JSONObject p = array.getJSONObject(i);
                boolean current = p.optBoolean("current");
                String uuid = p.getString("uuid");
                String name = p.getString("name");
                UserProfile profile = new UserProfile(uuid, name);
                profile.setPassword(p.optString("password", null));
                profile.setEmail(p.optString("email", null));
                ArrayList<SiteProfile> siteProfiles = new ArrayList<SiteProfile>();
                JSONArray array2 = p.optJSONArray("siteProfiles");
                int max2 = array2 != null ? array2.length() : 0;
                int j = 0;
                while (j < max2) {
                    try {
                        JSONObject sp = array2.getJSONObject(j);
                        String siteStr = sp.optString("site", null);
                        GeocacheSite site = EnumUtils.getEnum(GeocacheSite.class, siteStr);
                        String id = sp.optString("id", null);
                        String uuid2 = sp.optString("uuid", null);
                        String login = sp.optString("login", null);
                        SiteProfile siteProfile = new SiteProfile(site, id, uuid2, login);
                        siteProfile.setType(sp.optString("type", null));
                        siteProfile.setAvatarLink(URLUtils.create(sp.optString("avatar", null)));
                        siteProfiles.add(siteProfile);
                    }
                    catch (Throwable e) {
                        log.debug((Object)"Error", e);
                    }
                    ++j;
                }
                profile.setSiteProfiles(siteProfiles);
                this.userProfiles.add(profile);
                if (current) {
                    this.lastProfile = profile;
                }
                ++i;
            }
            if (StringUtils.isEmpty(this.appId)) {
                this.appId = UUID.randomUUID().toString();
                root.put("appId", (Object)this.appId);
                this.data.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        IConfigData iConfigData = this.data;
        synchronized (iConfigData) {
            JSONObject root = this.data.getObject("config");
            JSONArray array = JSONUtils.createArray(root, "userProfiles");
            for (UserProfile profile : this.userProfiles.getAllProfiles()) {
                JSONObject p = JSONUtils.createObject(array);
                p.put("uuid", (Object)profile.getUUID().toString());
                p.put("name", (Object)profile.getName());
                p.put("password", (Object)profile.getPassword());
                p.put("email", (Object)profile.getEmail());
                if (profile == this.currentProfile) {
                    p.put("current", true);
                }
                JSONArray spArray = JSONUtils.createArray(p, "siteProfiles");
                for (SiteProfile siteProfile : profile.getSiteProfiles()) {
                    JSONObject sp = JSONUtils.createObject(spArray);
                    sp.put("site", (Object)EnumUtils.getName(siteProfile.getSite()));
                    sp.put("login", (Object)siteProfile.getLogin());
                    sp.put("id", (Object)siteProfile.getId());
                    sp.put("uuid", (Object)siteProfile.getUuid());
                    sp.put("type", (Object)siteProfile.getType());
                    sp.put("avatar", (Object)StringUtils.toString(siteProfile.getAvatarLink()));
                }
            }
            this.data.save();
        }
    }

    public synchronized boolean registerUserProfile(UserProfile profile) throws UserProfileException {
        AssertUtils.notNull(profile, "Profile");
        if (this.userProfiles.containsUUID(profile)) {
            throw new UserProfileException("ERR_UUID_EXISTS");
        }
        if (this.userProfiles.containsName(profile)) {
            throw new UserProfileException("ERR_NAME_EXISTS");
        }
        if (!StorageService.getInstance().createUserHome(profile)) {
            throw new UserProfileException("ERR_STORAGE");
        }
        if (!this.userProfiles.add(profile)) {
            throw new UserProfileException("ERR_OTHER");
        }
        this.save();
        UsageServiceUtils.functionExecuted("userProfile.create", profile.getUUID(), profile.getName());
        return true;
    }

    public synchronized boolean removeUserProfile(UserProfile profile) throws UserProfileException {
        AssertUtils.notNull(profile, "Profile");
        if (!this.userProfiles.containsProfile(profile)) {
            throw new UserProfileException("ERR_NOT_REGISTERED");
        }
        if (!StorageService.getInstance().removeUserHome(profile)) {
            throw new UserProfileException("ERR_STORAGE");
        }
        if (!this.userProfiles.remove(profile)) {
            throw new UserProfileException("ERR_OTHER");
        }
        this.save();
        UsageServiceUtils.functionExecuted("userProfile.remove", profile.getUUID(), profile.getName());
        return true;
    }

    public synchronized boolean login(UserProfile profile, String password) throws UserProfileException {
        AssertUtils.notNull(profile, "Profile");
        if (!this.userProfiles.containsProfile(profile)) {
            throw new UserProfileException("ERR_NOT_REGISTERED");
        }
        if (this.currentProfile != profile) {
            this.logout();
            this.currentProfile = profile;
            this.save();
            this.notifyUserLogin(this.currentProfile);
            return true;
        }
        return false;
    }

    public synchronized boolean logout() {
        if (this.currentProfile != DEFAULT_PROFILE) {
            this.notifyUserLogout(this.currentProfile);
            this.lastProfile = this.currentProfile;
            this.currentProfile = DEFAULT_PROFILE;
            return true;
        }
        return false;
    }

    public synchronized UserProfile getUserProfileByUUID(String uuid) {
        return this.userProfiles.getProfileByUUID(uuid);
    }

    public synchronized UserProfile getUserProfileByName(String name) {
        return this.userProfiles.getProfileByName(name);
    }

    public synchronized List<UserProfile> getAllProfiles() {
        return this.userProfiles.getAllProfiles();
    }

    public synchronized UserProfile getCurrentProfile() {
        return this.currentProfile;
    }

    public synchronized UserProfile getLastProfile() {
        return this.lastProfile;
    }

    public synchronized boolean isPasswordProtected(UserProfile profile) {
        return profile != null && profile.getPassword() != null;
    }

    public synchronized boolean checkPassword(UserProfile profile, String password) {
        return profile != null && profile.checkPassword(password);
    }

    public boolean isDefaultProfile(UserProfile profile) {
        return DEFAULT_PROFILE.equals(profile);
    }

    public String getAppId() {
        return this.appId;
    }

    synchronized void siteAdded(UserProfile userProfile, SiteProfile siteProfile) {
        AssertUtils.notNull(userProfile, "UserProfile");
        AssertUtils.notNull(siteProfile, "SiteProfile");
        if (!this.userProfiles.containsProfile(userProfile)) {
            return;
        }
        UsageServiceUtils.functionExecuted("siteProfile.added", userProfile.getUUID(), siteProfile.getSite().name(), siteProfile.getLogin(), siteProfile.getId(), siteProfile.getUuid());
        this.save();
        this.notifySiteAdded(userProfile, siteProfile);
    }

    synchronized void siteRemoved(UserProfile userProfile, SiteProfile siteProfile) {
        AssertUtils.notNull(userProfile, "UserProfile");
        AssertUtils.notNull(siteProfile, "SiteProfile");
        if (!this.userProfiles.containsProfile(userProfile)) {
            return;
        }
        UsageServiceUtils.functionExecuted("siteProfile.removed", userProfile.getUUID(), siteProfile.getSite().name(), siteProfile.getLogin(), siteProfile.getId(), siteProfile.getUuid());
        this.save();
        this.notifySiteRemoved(userProfile, siteProfile);
    }

    @Override
    public synchronized void addListener(UserProfileListener listener) {
        AssertUtils.notNull(listener, "Listener");
        this.listenerList.addListener(listener);
        if (this.currentProfile != DEFAULT_PROFILE) {
            listener.currentUser(this.currentProfile);
        }
    }

    @Override
    public synchronized void removeListener(UserProfileListener listener) {
        AssertUtils.notNull(listener, "Listener");
        this.listenerList.removeListener(listener);
    }

    protected void notifyUserLogin(UserProfile profile) {
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add(profile.getUUID());
        attrs.add(profile.getName());
        for (SiteProfile siteProfile : profile.getSiteProfiles()) {
            attrs.add(siteProfile.toString());
        }
        UsageServiceUtils.functionExecuted("userProfile.login", attrs.toArray(new String[attrs.size()]));
        for (UserProfileListener listener : this.listenerList.getListeners()) {
            listener.userLogin(profile);
        }
    }

    protected void notifyUserLogout(UserProfile profile) {
        UsageServiceUtils.functionExecuted("userProfile.logout", this.currentProfile.getUUID(), this.currentProfile.getName());
        for (UserProfileListener listener : this.listenerList.getListeners()) {
            listener.userLogout(profile);
        }
    }

    protected void notifySiteAdded(UserProfile userProfile, SiteProfile siteProfile) {
        for (UserProfileListener listener : this.listenerList.getListeners()) {
            listener.siteAdded(userProfile, siteProfile);
        }
    }

    protected void notifySiteRemoved(UserProfile userProfile, SiteProfile siteProfile) {
        for (UserProfileListener listener : this.listenerList.getListeners()) {
            listener.siteRemoved(userProfile, siteProfile);
        }
    }

    private class UserProfiles {
        private final Set<UserProfile> profiles = new HashSet<UserProfile>();
        private final Map<String, UserProfile> profilesByUUID = new HashMap<String, UserProfile>();
        private final Map<String, UserProfile> profilesByName = new HashMap<String, UserProfile>();

        public void clear() {
            this.profiles.clear();
            this.profilesByUUID.clear();
            this.profilesByName.clear();
        }

        public boolean add(UserProfile profile) {
            if (!this.containsUUID(profile) && !this.containsName(profile) && this.profiles.add(profile)) {
                this.profilesByUUID.put(profile.getUUID(), profile);
                this.profilesByName.put(profile.getName(), profile);
                return true;
            }
            return false;
        }

        public boolean remove(UserProfile profile) {
            if (this.profiles.remove(profile)) {
                this.profilesByUUID.remove(profile.getUUID());
                this.profilesByName.remove(profile.getName());
                return true;
            }
            return false;
        }

        public UserProfile getProfileByUUID(String uuid) {
            return this.profilesByUUID.get(uuid);
        }

        public UserProfile getProfileByName(String name) {
            return this.profilesByName.get(name);
        }

        public List<UserProfile> getAllProfiles() {
            return new ArrayList<UserProfile>(this.profiles);
        }

        private boolean containsProfile(UserProfile profile) {
            return this.profiles.contains(profile);
        }

        private boolean containsUUID(UserProfile profile) {
            return this.profilesByUUID.containsKey(profile.getUUID());
        }

        private boolean containsName(UserProfile profile) {
            return this.profilesByName.containsKey(profile.getName());
        }
    }
}

