/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.SiteProfile;
import geocentral.common.app.UserProfileService;
import geocentral.common.geocaching.GeocacheSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.bacza.utils.ThreadUtils;

public class UserProfile {
    private final String uuid;
    private final String name;
    private String password;
    private String email;
    private final Map<GeocacheSite, SiteProfile> siteProfiles;

    public UserProfile(String uuid, String name) {
        AssertUtils.notEmpty(uuid, "UUID");
        AssertUtils.notEmpty(name, "Name");
        this.uuid = uuid;
        this.name = name;
        this.siteProfiles = new TreeMap<GeocacheSite, SiteProfile>();
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordPlainText(String password) {
        this.password = DigestUtils.sha256Hex((String)password);
    }

    public boolean checkPassword(String password) {
        int cmp = StringUtils.compare(this.password, DigestUtils.sha256Hex((String)password));
        if (cmp != 0) {
            ThreadUtils.sleep(250L);
            return false;
        }
        return true;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    synchronized void setSiteProfiles(List<SiteProfile> siteProfiles) {
        if (siteProfiles != null) {
            for (SiteProfile siteProfile : siteProfiles) {
                if (siteProfile == null) continue;
                this.siteProfiles.put(siteProfile.getSite(), siteProfile);
            }
        }
    }

    public synchronized void addSiteProfile(SiteProfile siteProfile) {
        if (siteProfile != null) {
            GeocacheSite site = siteProfile.getSite();
            AssertUtils.notNull((Object)site, "Site");
            this.siteProfiles.put(site, siteProfile);
            UserProfileService.getInstance().siteAdded(this, siteProfile);
        }
    }

    public synchronized void removeSiteProfile(GeocacheSite site) {
        SiteProfile siteProfile;
        if (site != null && (siteProfile = this.siteProfiles.remove((Object)site)) != null) {
            UserProfileService.getInstance().siteRemoved(this, siteProfile);
        }
    }

    public synchronized boolean hasSiteProfile(GeocacheSite site) {
        AssertUtils.notNull((Object)site, "Site");
        return this.siteProfiles.containsKey((Object)site);
    }

    public synchronized SiteProfile getSiteProfile(GeocacheSite site) {
        AssertUtils.notNull((Object)site, "Site");
        return this.siteProfiles.get((Object)site);
    }

    public synchronized List<GeocacheSite> getSites() {
        return Collections.unmodifiableList(new ArrayList<GeocacheSite>(this.siteProfiles.keySet()));
    }

    public synchronized List<SiteProfile> getSiteProfiles() {
        return Collections.unmodifiableList(new ArrayList<SiteProfile>(this.siteProfiles.values()));
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof UserProfile) {
            return this.uuid.equals(((UserProfile)other).uuid);
        }
        return false;
    }

    public String toString() {
        return String.format("%s (%s)", this.name, this.uuid);
    }
}

