/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.UserProfile;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.FileUtils;
import org.bacza.utils.IOUtils;

public final class StorageService {
    public static final String WORK_PATH = System.getProperty("user.dir");
    public static final String USER_HOME_PATH = System.getProperty("user.home");
    public static final String APP_HOME_PATH = FileUtils.combinePath(USER_HOME_PATH, ".geocentral-lite");
    public static final String DATA_COMMON_PATH = FileUtils.combinePath(APP_HOME_PATH, "common");
    public static final String DATA_SYSTEM_PATH = FileUtils.combinePath(APP_HOME_PATH, "system");
    public static final String DATA_USERS_PATH = FileUtils.combinePath(APP_HOME_PATH, "users");
    public static final String DATA_LOGS_PATH = FileUtils.combinePath(APP_HOME_PATH, "logs");
    private static final String APP_LOCKFILE = FileUtils.combinePath(APP_HOME_PATH, "geocentral.lck");
    private static final StorageService instance = new StorageService();
    private RandomAccessFile lockFile = null;

    private StorageService() {
        FileUtils.mkdirs(APP_HOME_PATH);
        FileUtils.mkdirs(DATA_COMMON_PATH);
        FileUtils.mkdirs(DATA_SYSTEM_PATH);
        FileUtils.mkdirs(DATA_USERS_PATH);
        FileUtils.mkdirs(DATA_LOGS_PATH);
    }

    public static StorageService getInstance() {
        return instance;
    }

    public String getAppHomePath() {
        return APP_HOME_PATH;
    }

    public String getAppHomePath(String filename) {
        AssertUtils.notNull(filename, "File name");
        return FileUtils.combinePath(APP_HOME_PATH, filename);
    }

    public String getCommonPath() {
        return DATA_COMMON_PATH;
    }

    public String getSystemPath() {
        return DATA_SYSTEM_PATH;
    }

    public String getSystemPath(String filename) {
        AssertUtils.notNull(filename, "File name");
        return FileUtils.combinePath(DATA_SYSTEM_PATH, filename);
    }

    protected boolean createUserHome(UserProfile profile) {
        AssertUtils.notNull(profile, "UserProfile");
        String path = FileUtils.combinePath(DATA_USERS_PATH, profile.getName());
        FileUtils.mkdirs(path);
        return FileUtils.dirExists(path);
    }

    protected boolean removeUserHome(UserProfile profile) {
        AssertUtils.notNull(profile, "UserProfile");
        String path = FileUtils.combinePath(DATA_USERS_PATH, profile.getName());
        if (FileUtils.dirExists(path)) {
            try {
                FileUtils.rmdir(path);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public String getUserPath(UserProfile profile) {
        AssertUtils.notNull(profile, "UserProfile");
        return FileUtils.combinePath(DATA_USERS_PATH, profile.getName());
    }

    public String getUserPath(UserProfile profile, String filename) {
        AssertUtils.notNull(profile, "UserProfile");
        AssertUtils.notNull(filename, "File name");
        return FileUtils.combinePath(this.getUserPath(profile), filename);
    }

    public String getLogsPath() {
        return DATA_LOGS_PATH;
    }

    public String getLogsPath(String filename) {
        AssertUtils.notNull(filename, "File name");
        return FileUtils.combinePath(DATA_LOGS_PATH, filename);
    }

    public synchronized boolean createLockFile() {
        if (this.lockFile != null) {
            return true;
        }
        try {
            RandomAccessFile f = new RandomAccessFile(APP_LOCKFILE, "rw");
            f.setLength(0L);
            if (f.getChannel().tryLock() != null) {
                this.lockFile = f;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public synchronized boolean removeLockFile() {
        if (this.lockFile != null) {
            IOUtils.close(this.lockFile);
            this.lockFile = null;
            return FileUtils.deleteFile(APP_LOCKFILE);
        }
        return true;
    }
}

