/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.LoggerFilter;
import geocentral.common.app.LoggerOverride;
import geocentral.common.app.StorageService;
import geocentral.common.ui.preferences.PreferenceStoreManager;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.LogUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class LoggerManager {
    private static Log log;
    private static final LoggerManager instance;
    private static final String FH_FILENAME = "geocentral_%g.log";
    private static final int FH_LIMIT = 0xA00000;
    private static final int FH_COUNT = 10;
    private List<LoggerOverride> overrides = new LinkedList<LoggerOverride>();
    private ConsoleHandler consoleHandler = null;
    private FileHandler fileHandler = null;

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] [%4$-7s] [%2$s] - %5$s%6$s%n");
        log = LogFactory.getLog(LoggerManager.class);
        instance = new LoggerManager();
    }

    private LoggerManager() {
        this.addOverride(new LoggerOverride("okhttp3.internal", Level.INFO));
        this.addOverride(new LoggerOverride("io.socket", Level.INFO));
        this.addOverride(new LoggerOverride("sun.awt", Level.INFO));
        this.addOverride(new LoggerOverride("jdk", Level.INFO));
        PreferenceStoreManager.getStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("geocentral.preferences.log.console_level".equals(event.getProperty())) {
                    log.info((Object)"Reconfiguring console logger...");
                    LoggerManager.this.configureConsoleLogger();
                }
                if ("geocentral.preferences.log.file_level".equals(event.getProperty())) {
                    log.info((Object)"Reconfiguring file logger...");
                    LoggerManager.this.configureFileLogger();
                }
            }
        });
        this.init();
    }

    public static LoggerManager getInstance() {
        return instance;
    }

    private void init() {
        Logger logger = LogUtils.getRootLogger();
        LogUtils.removeAllHandlers(logger);
        logger.setLevel(Level.OFF);
    }

    public synchronized void configure() {
        this.configureConsoleLogger();
        this.configureFileLogger();
    }

    private synchronized void configureConsoleLogger() {
        Logger logger = LogUtils.getRootLogger();
        Level level = this.mapLevel(PreferenceStoreManager.getStore().getString("geocentral.preferences.log.console_level"));
        if (Level.OFF.equals(level)) {
            if (this.consoleHandler != null) {
                logger.removeHandler(this.consoleHandler);
                this.consoleHandler.flush();
                this.consoleHandler.close();
                this.consoleHandler = null;
            }
        } else {
            if (this.consoleHandler == null) {
                this.consoleHandler = this.createConsoleHandler();
                this.addHandler(logger, this.consoleHandler);
            }
            this.consoleHandler.flush();
            this.consoleHandler.setLevel(level);
            this.consoleHandler.setFilter(new LoggerFilter(this.overrides));
        }
        this.setLoggerLevel(logger);
    }

    private synchronized void configureFileLogger() {
        Logger logger = LogUtils.getRootLogger();
        Level level = this.mapLevel(PreferenceStoreManager.getStore().getString("geocentral.preferences.log.file_level"));
        if (Level.OFF.equals(level)) {
            if (this.fileHandler != null) {
                logger.removeHandler(this.fileHandler);
                this.fileHandler.flush();
                this.fileHandler.close();
                this.fileHandler = null;
            }
        } else {
            if (this.fileHandler == null) {
                this.fileHandler = this.createFileHandler();
                this.addHandler(logger, this.fileHandler);
            }
            this.fileHandler.flush();
            this.fileHandler.setLevel(level);
            this.fileHandler.setFilter(new LoggerFilter(this.overrides));
        }
        this.setLoggerLevel(logger);
    }

    private void setLoggerLevel(Logger logger) {
        Level l2;
        Level l1 = this.consoleHandler != null ? this.consoleHandler.getLevel() : Level.OFF;
        Level level = l2 = this.fileHandler != null ? this.fileHandler.getLevel() : Level.OFF;
        if (l1.intValue() < l2.intValue()) {
            logger.setLevel(l1);
        } else {
            logger.setLevel(l2);
        }
    }

    private Level mapLevel(String level) {
        return this.mapLevel(StringUtils.parseInt(level, 0));
    }

    private Level mapLevel(int level) {
        level = Math.min(Math.max(level, 0), 3);
        switch (level) {
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.FINE;
            }
            case 3: {
                return Level.FINEST;
            }
        }
        return Level.OFF;
    }

    public void addOverride(LoggerOverride override) {
        if (override != null) {
            this.overrides.add(override);
        }
    }

    private ConsoleHandler createConsoleHandler() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        return handler;
    }

    private FileHandler createFileHandler() {
        try {
            String filename = StorageService.getInstance().getLogsPath(FH_FILENAME);
            FileHandler handler = new FileHandler(filename, 0xA00000, 10, true);
            handler.setFormatter(new SimpleFormatter());
            return handler;
        }
        catch (IOException e) {
            log.info((Object)"Error creating file handler", (Throwable)e);
            return null;
        }
    }

    private void addHandler(Logger logger, Handler handler) {
        try {
            logger.addHandler(handler);
        }
        catch (SecurityException e) {
            log.info((Object)"Error adding handler", (Throwable)e);
        }
    }
}

