/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.LanguageListener;
import geocentral.common.app.SystemConfigService;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bacza.events.EventSource;
import org.bacza.events.ListenerList;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public final class LanguageService
implements EventSource<LanguageListener> {
    private static final String CONFIG_KEY = "geocentral.system.lang";
    private static final Locale ENG_LOCALE = Locale.ENGLISH;
    private static final String ENG_LANG = ENG_LOCALE.getLanguage();
    private static final LanguageService instance = new LanguageService();
    private final ListenerList<LanguageListener> listenerList = new ListenerList();
    private final Map<String, Locale> map = new HashMap<String, Locale>();
    private final List<String> list = new LinkedList<String>();
    private String current;

    public static LanguageService getInstance() {
        return instance;
    }

    private LanguageService() {
        this.init();
        this.initCurrent();
    }

    private void init() {
        this.registerLanguage(ENG_LANG);
        this.registerLanguage("pl");
    }

    private void initCurrent() {
        String tag = SystemConfigService.getInstance().getString(CONFIG_KEY);
        this.setLanguageImpl(tag, false);
    }

    public synchronized boolean registerLanguage(String tag) {
        Locale locale;
        if (tag != null && (locale = Locale.forLanguageTag(tag)) != null && StringUtils.notEmpty(locale.getLanguage()) && !this.map.containsKey(tag)) {
            this.map.put(tag, locale);
            this.list.add(tag);
            return true;
        }
        return false;
    }

    public synchronized List<String> getAllLanguages() {
        return Collections.unmodifiableList(this.list);
    }

    public synchronized String getLanguage() {
        return this.current;
    }

    public synchronized boolean setLanguage(String tag) {
        return this.setLanguageImpl(tag, true);
    }

    private boolean setLanguageImpl(String tag, boolean save) {
        Locale locale;
        if (StringUtils.notEmpty(tag) && !StringUtils.equals(tag, this.current) && (locale = this.map.get(tag)) != null) {
            Locale.setDefault(locale);
            this.current = tag;
            this.notifyLanguageChanged(tag);
            if (save) {
                SystemConfigService.getInstance().setString(CONFIG_KEY, tag);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addListener(LanguageListener listener) {
        AssertUtils.notNull(listener, "Listener");
        this.listenerList.addListener(listener);
    }

    @Override
    public void removeListener(LanguageListener listener) {
        AssertUtils.notNull(listener, "Listener");
        this.listenerList.removeListener(listener);
    }

    private void notifyLanguageChanged(String tag) {
        for (LanguageListener listener : this.listenerList.getListeners()) {
            listener.languageChanged(tag);
        }
    }

    public synchronized String getDisplayName(String tag) {
        return this.getDisplayName(this.map.get(tag));
    }

    public synchronized String getDisplayName(Locale locale) {
        if (locale != null) {
            String tag = StringUtils.toUpperCase(locale.getLanguage());
            String lang1 = StringUtils.coalesce(locale.getDisplayLanguage(ENG_LOCALE), locale.getDisplayName(ENG_LOCALE), locale.getLanguage(), locale.toLanguageTag());
            String lang2 = StringUtils.coalesce(locale.getDisplayLanguage(), locale.getDisplayName(), locale.getLanguage(), locale.toLanguageTag());
            if (StringUtils.equalsIgnoreCase(lang1, lang2)) {
                return String.format("%s - %s", tag, lang1);
            }
            return String.format("%s - %s (%s)", tag, lang1, lang2);
        }
        return null;
    }
}

