/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.StorageService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.FileUtils;
import org.bacza.utils.StringUtils;

public final class ConfigManager {
    public static final String FILENAME = "config.ini";
    private static final Log log = LogFactory.getLog(ConfigManager.class);
    private final Properties props = new Properties();
    private static final ConfigManager instance = new ConfigManager();

    public static ConfigManager getInstance() {
        return instance;
    }

    private ConfigManager() {
        this.load();
    }

    private String getFilename() {
        return StorageService.getInstance().getAppHomePath(FILENAME);
    }

    private String getFileDesc() {
        return "GeoCentral user config file.";
    }

    public synchronized void load() {
        String filename = this.getFilename();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileInputStream stream = new FileInputStream(filename);){
                this.props.clear();
                this.props.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            log.trace((Object)String.format("Config file not found: %s", filename));
        }
        catch (IOException e) {
            log.debug((Object)"Exception", (Throwable)e);
        }
    }

    public synchronized void save() {
        String filename = this.getFilename();
        try {
            FileUtils.createPath(filename, true);
        }
        catch (IOException e) {
            log.debug((Object)String.format("Could not create config file: %s", filename), (Throwable)e);
            return;
        }
        try {
            Throwable e = null;
            Object var3_7 = null;
            try (FileOutputStream stream = new FileOutputStream(filename);){
                this.props.store(stream, this.getFileDesc());
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            log.debug((Object)String.format("Config file not found: %s", filename));
        }
        catch (IOException e) {
            log.debug((Object)"Exception", (Throwable)e);
        }
    }

    public synchronized void setString(String key, String value) {
        if (StringUtils.notEmpty(key)) {
            this.props.setProperty(key, value);
        }
    }

    public synchronized String getString(String key) {
        return this.props.getProperty(key);
    }

    public synchronized String getString(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public synchronized void setBoolean(String key, Boolean value) {
        if (StringUtils.notEmpty(key)) {
            if (value == null) {
                value = false;
            }
            this.props.setProperty(key, value.toString());
        }
    }

    public synchronized Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.props.getProperty(key, null);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }
}

