/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.common.app.IConfigData;
import geocentral.common.app.StorageService;
import geocentral.common.app.UserProfile;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.FileUtils;
import org.bacza.utils.IOUtils;
import org.bacza.utils.StringEncoder;
import org.bacza.utils.StringUtils;
import org.bacza.utils.Timer;
import org.json.JSONObject;

public final class ConfigDataService {
    private static final Log log = LogFactory.getLog(ConfigDataService.class);
    public static final String SYSTEM_CONFIG_FILE = "system-config.json";
    public static final String USER_CONFIG_FILE = "user-config.json";
    private static final ConfigDataService instance = new ConfigDataService();
    private final Map<String, ConfigData> configs = new HashMap<String, ConfigData>();

    public static ConfigDataService getInstance() {
        return instance;
    }

    private ConfigDataService() {
    }

    private String getResourceConfigId(Class<?> clazz, String path) {
        return String.format("resource::%s::%s", clazz.getName(), path);
    }

    private String getSystemConfigId(String filename) {
        return String.format("system::%s", filename);
    }

    private String getUserConfigId(UserProfile profile, String filename) {
        return String.format("user::%s::%s", profile.getUUID(), filename);
    }

    public synchronized void shutdown() {
        for (ConfigData config : this.configs.values()) {
            IOUtils.close(config);
        }
    }

    public synchronized IConfigData getResourceData(Class<?> clazz, String path) {
        return this.getResourceData(clazz, path, false);
    }

    public synchronized IConfigData getResourceData(Class<?> clazz, String path, boolean secret) {
        AssertUtils.notNull(clazz, "class");
        AssertUtils.notEmpty(path, "path");
        String id = this.getResourceConfigId(clazz, path);
        return this.getConfigData(id, path, clazz, secret);
    }

    public synchronized IConfigData getSystemData() {
        return this.getSystemData(SYSTEM_CONFIG_FILE);
    }

    public synchronized IConfigData getSystemData(String filename) {
        return this.getSystemData(filename, false);
    }

    public synchronized IConfigData getSystemData(String filename, boolean secret) {
        AssertUtils.notEmpty(filename, "filename");
        String id = this.getSystemConfigId(filename);
        String path = StorageService.getInstance().getSystemPath(filename);
        return this.getConfigData(id, path, null, secret);
    }

    public synchronized IConfigData getUserData(UserProfile profile) {
        return this.getUserData(profile, USER_CONFIG_FILE);
    }

    public synchronized IConfigData getUserData(UserProfile profile, String filename) {
        return this.getUserData(profile, filename, false);
    }

    public synchronized IConfigData getUserData(UserProfile profile, String filename, boolean secret) {
        AssertUtils.notNull(profile, "profile");
        AssertUtils.notEmpty(filename, "filename");
        String id = this.getUserConfigId(profile, filename);
        String path = StorageService.getInstance().getUserPath(profile, filename);
        return this.getConfigData(id, path, null, secret);
    }

    private ConfigData getConfigData(String id, String path, Class<?> clazz, boolean secret) {
        AssertUtils.notEmpty(id, "id");
        AssertUtils.notEmpty(path, "path");
        ConfigData data = this.configs.get(id);
        if (data == null) {
            data = this.createConfigData(path, clazz, secret);
            this.configs.put(id, data);
        }
        return data;
    }

    private ConfigData createConfigData(String path, Class<?> clazz, boolean secret) {
        AssertUtils.notEmpty(path, "path");
        ConfigData data = new ConfigData(path, clazz, secret);
        try {
            data.load();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return data;
    }

    private class ConfigData
    implements IConfigData,
    Serializable,
    Closeable {
        private static final long serialVersionUID = 2378114794551960842L;
        private final String path;
        private final Class<?> clazz;
        private final StringEncoder encoder;
        private final Timer saveTimer;
        private JSONObject root;
        private boolean dirty;

        public ConfigData(String path, Class<?> clazz, boolean secret) {
            this.path = path;
            this.clazz = clazz;
            this.encoder = secret ? new StringEncoder(new StringBuilder(String.valueOf(2378114794551960842L)).reverse().toString()) : null;
            this.saveTimer = clazz != null ? null : new Timer("ConfigData Sync", 1000L, new Runnable(){

                @Override
                public void run() {
                    ConfigData.this.saveImpl();
                }
            });
            this.dirty = false;
        }

        private synchronized void load() throws IOException {
            this.root = new JSONObject();
            byte[] bytes = null;
            bytes = this.clazz != null ? FileUtils.readResourceAsBytes(this.clazz, this.path) : FileUtils.readFileAsBytes(this.path);
            if (bytes != null) {
                String str = null;
                str = this.encoder != null ? this.encoder.decrypt(Base64.decodeBase64((byte[])bytes)) : new String(bytes, StandardCharsets.UTF_8);
                if (StringUtils.notEmpty(StringUtils.trim(str))) {
                    this.root = new JSONObject(str);
                    return;
                }
            }
        }

        @Override
        public synchronized JSONObject getObject(String key) {
            AssertUtils.notEmpty(key, "key");
            JSONObject value = this.root.optJSONObject(key);
            if (value == null) {
                value = new JSONObject();
                this.root.put(key, (Object)value);
            }
            return value;
        }

        @Override
        public synchronized void save() {
            if (this.saveTimer != null) {
                this.dirty = true;
                this.saveTimer.restart();
            }
        }

        private synchronized void saveImpl() {
            if (!this.dirty) {
                return;
            }
            try {
                String data = this.root.toString(2);
                if (this.encoder != null) {
                    FileUtils.writeFile(this.path, Base64.encodeBase64((byte[])this.encoder.encrypt(data), (boolean)true));
                } else {
                    FileUtils.writeFile(this.path, data);
                }
                this.dirty = false;
            }
            catch (IOException e) {
                log.debug((Object)("Error saving config data: " + e.getMessage()));
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.saveTimer != null) {
                this.saveTimer.stop();
                if (this.dirty) {
                    this.saveImpl();
                }
            }
        }
    }
}

