/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.app;

import geocentral.app.AboutDialog;
import geocentral.common.Messages;
import geocentral.common.app.UserProfile;
import geocentral.common.app.UserProfileService;
import geocentral.common.ui.DialogUtils;
import org.bacza.http.URLUtils;
import org.bacza.utils.DesktopUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

public class BMCDialog
extends TitleAreaDialog {
    public static final int ID_OK = 0;
    public static final int ID_CANCEL = 1;
    public static final int ID_BUY = 1025;
    public boolean alreadyClicked;
    public boolean buyClicked;
    private String username;
    private boolean paid;
    private Composite stack;
    private Composite layerBuy;
    private Composite layerThanks;
    private Composite layerAlready;

    public BMCDialog(Shell parentShell, boolean paid) {
        super(parentShell);
        String username;
        this.setHelpAvailable(false);
        this.username = null;
        this.paid = paid;
        this.alreadyClicked = false;
        this.buyClicked = false;
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        if (!UserProfileService.getInstance().isDefaultProfile(profile) && StringUtils.notEmpty(username = profile.getName())) {
            this.username = StringUtils.substring(username, 30);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("BMCDialog.title"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.marginWidth = 0;
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        container.setLayoutData((Object)new GridData(1808));
        Composite composite1 = new Composite(container, 0);
        GridData gd_composite1 = new GridData(4, 4, false, true, 1, 1);
        gd_composite1.widthHint = 350;
        composite1.setLayoutData((Object)gd_composite1);
        Label label = new Label(composite1, 0);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BMCDialog.this.openSite();
            }
        });
        label.setCursor(SWTResourceManager.getCursor(21));
        label.setAlignment(0x1000000);
        label.setImage(SWTResourceManager.getImage(BMCDialog.class, "/images/bmc-yellow-sm.png"));
        label.setBounds(20, 44, 320, 90);
        this.stack = new Composite(container, 0);
        this.stack.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        StackLayout sl_stack = new StackLayout();
        sl_stack.marginWidth = 8;
        this.stack.setLayout((Layout)sl_stack);
        this.layerBuy = new Composite(this.stack, 0);
        this.layerBuy.setLayout((Layout)new GridLayout(1, false));
        new Label(this.layerBuy, 0);
        String label_10_text = this.username == null ? Messages.getString("BMCDialog.buy.line1") : String.format(Messages.getString("BMCDialog.buy.line1personal"), this.username);
        Label label_10 = new Label(this.layerBuy, 64);
        label_10.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_10.setText(label_10_text);
        label_10.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        Label label_11 = new Label(this.layerBuy, 64);
        label_11.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_11.setText(Messages.getString("BMCDialog.buy.line2"));
        Label label_12 = new Label(this.layerBuy, 64);
        label_12.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_12.setText(Messages.getString("BMCDialog.buy.line3"));
        Label label_13 = new Label(this.layerBuy, 64);
        label_13.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_13.setText(Messages.getString("BMCDialog.buy.line4"));
        this.layerThanks = new Composite(this.stack, 0);
        this.layerThanks.setLayout((Layout)new GridLayout(1, false));
        new Label(this.layerThanks, 0);
        Label label_20 = new Label(this.layerThanks, 64);
        label_20.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_20.setText(Messages.getString("BMCDialog.thanks.line1"));
        label_20.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        Label label_21 = new Label(this.layerThanks, 64);
        label_21.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_21.setText(Messages.getString("BMCDialog.thanks.line2"));
        Label label_22 = new Label(this.layerThanks, 64);
        label_22.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_22.setText(Messages.getString("BMCDialog.thanks.line3"));
        Label label_23 = new Label(this.layerThanks, 64);
        label_23.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_23.setText(Messages.getString("BMCDialog.thanks.line4"));
        Label separator1 = new Label(container, 258);
        separator1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.layerAlready = new Composite(this.stack, 0);
        this.layerAlready.setLayout((Layout)new GridLayout(1, false));
        new Label(this.layerAlready, 0);
        Label label_31 = new Label(this.layerAlready, 64);
        label_31.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_31.setText(Messages.getString("BMCDialog.done.line1"));
        label_31.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        Label label_32 = new Label(this.layerAlready, 64);
        label_32.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label_32.setText(Messages.getString("BMCDialog.done.line2"));
        new Label(this.layerAlready, 0);
        Button btnAbout = new Button(this.layerAlready, 0);
        btnAbout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AboutDialog dlg = new AboutDialog(BMCDialog.this.getShell());
                dlg.open();
            }
        });
        btnAbout.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        btnAbout.setText(Messages.getString("BMCDialog.done.checkId"));
        this.showLayer((Control)(this.paid ? this.layerThanks : this.layerBuy));
        return area;
    }

    protected Control createButtonBar(final Composite parent) {
        final Composite buttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonBar.setLayout((Layout)layout);
        GridData data = new GridData(4, 1024, true, false);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        buttonBar.setLayoutData((Object)data);
        buttonBar.setFont(parent.getFont());
        if (!this.paid && !this.alreadyClicked) {
            Button leftButton = new Button(buttonBar, 8);
            leftButton.setText(Messages.getString("BMCDialog.btn.alreadySupported"));
            leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BMCDialog.this.alreadyClicked = true;
                    BMCDialog.this.showLayer((Control)BMCDialog.this.layerAlready);
                    buttonBar.dispose();
                    BMCDialog.this.createButtonBar(parent);
                    parent.layout();
                }
            });
            GridData leftButtonData = new GridData(16384, 0x1000000, true, true);
            leftButtonData.grabExcessHorizontalSpace = true;
            leftButtonData.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            Point minSize = leftButton.computeSize(-1, -1, true);
            leftButtonData.widthHint = Math.max(widthHint, minSize.x);
            leftButton.setLayoutData((Object)leftButtonData);
        }
        Control buttonControl = super.createButtonBar(buttonBar);
        buttonControl.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.paid || this.alreadyClicked) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            Button btnOK = this.createButton(parent, 1025, Messages.getString("BMCDialog.btn.willSupport"), true);
            btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BMCDialog.this.openSite();
                }
            });
            this.createButton(parent, 1, Messages.getString("BMCDialog.btn.notNow"), false);
        }
    }

    protected Point getInitialSize() {
        return new Point(700, 410);
    }

    protected void showLayer(Control control) {
        StackLayout layout = (StackLayout)this.stack.getLayout();
        layout.topControl = control;
        this.stack.layout();
    }

    protected void openSite() {
        this.buyClicked = true;
        if (!DesktopUtils.openUrl("https://www.buymeacoffee.com/bacza")) {
            String url = URLUtils.stripProtocol("https://www.buymeacoffee.com/bacza");
            String msg = String.format("%s\n\n%s", Messages.getString("BMCDialog.visitSite"), url);
            DialogUtils.showInfo(msg);
        }
    }
}

