/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.actions;

import geocentral.common.actions.AppContext;
import geocentral.common.actions.IActionContext;
import geocentral.common.actions.IActionSender;
import org.bacza.utils.AssertUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ActionContext
implements IActionContext {
    private IProgressMonitor monitor;
    private AppContext appContext;
    private int tasksStarted;

    public ActionContext(IProgressMonitor monitor, AppContext appContext) {
        AssertUtils.notNull(monitor, "Monitor");
        AssertUtils.notNull(appContext, "AppContext");
        this.monitor = monitor;
        this.appContext = appContext;
        this.tasksStarted = 0;
    }

    @Override
    public void beginTask(String name) {
        this.beginTask(name, -1);
    }

    @Override
    public void beginTask(String name, int totalWork) {
        if (this.monitor != null) {
            if (this.tasksStarted > 0) {
                this.monitor.subTask(name);
            } else {
                this.monitor.beginTask(name, totalWork > 0 ? totalWork : -1);
            }
        }
        ++this.tasksStarted;
    }

    @Override
    public void beginSubtask(String name) {
        if (this.monitor != null) {
            this.monitor.subTask(name);
        }
    }

    @Override
    public void worked(int work) {
        if (this.monitor != null) {
            this.monitor.worked(work);
        }
    }

    @Override
    public void done() {
        if (this.tasksStarted > 0) {
            --this.tasksStarted;
            if (this.tasksStarted == 0 && this.monitor != null) {
                this.monitor.done();
            }
        }
    }

    @Override
    public boolean isCancelled() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }

    @Override
    public IActionSender getSender() {
        return this.appContext.getSender();
    }

    @Override
    public Object getAppContext(String paramId) {
        return this.appContext.getParameter(paramId);
    }
}

