/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common;

import geocentral.common.ui.DisplayUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class KeyStatusService {
    private static final KeyStatusService instance = new KeyStatusService();
    private Listener listener = new Listener(){

        public void handleEvent(Event e) {
            KeyStatusService.this.updateStatus(e);
        }
    };
    private boolean keyPressedMod1 = false;
    private boolean keyPressedMod2 = false;
    private boolean keyPressedMod3 = false;

    public static KeyStatusService getInstance() {
        return instance;
    }

    private KeyStatusService() {
        Display display = DisplayUtils.getDisplay();
        display.addFilter(1, this.listener);
        display.addFilter(2, this.listener);
    }

    private void updateStatus(Event e) {
        boolean down = (e.type & 1) != 0;
        this.keyPressedMod1 = down && (e.keyCode & 0x40000) != 0;
        this.keyPressedMod2 = down && (e.keyCode & 0x20000) != 0;
        this.keyPressedMod3 = down && (e.keyCode & 0x10000) != 0;
    }

    public boolean isMod1Pressed() {
        return this.keyPressedMod1;
    }

    public boolean isMod2Pressed() {
        return this.keyPressedMod2;
    }

    public boolean isMod3Pressed() {
        return this.keyPressedMod3;
    }
}

