/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.opencaching;

import geocentral.api.groundspeak.InvalidLogTypeException;
import geocentral.api.oauth.OAuthConsumerException;
import geocentral.api.oauth.OAuthHelper;
import geocentral.api.oauth.OAuthService;
import geocentral.api.opencaching.OkapiWebExecutor;
import geocentral.api.opencaching.data.OkapiGeocacheLogTypeInputMapper;
import geocentral.api.opencaching.data.OkapiGeocacheLogTypeMapper;
import geocentral.api.opencaching.data.OkapiGeocacheTypeMapper;
import geocentral.common.app.SiteProfile;
import geocentral.common.app.UserProfile;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.GeocacheItem;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheMapperUtils;
import geocentral.common.geocaching.GeocacheSize;
import geocentral.common.geocaching.GeocacheType;
import geocentral.common.geocaching.GeocachingTaskNames;
import geocentral.common.geocaching.IInputGeocacheSizeMapper;
import geocentral.common.geocaching.IInputGeocacheTypeMapper;
import geocentral.common.geocaching.api.GeocachingApiAssertUtils;
import geocentral.common.geocaching.api.IGeocachingApi;
import geocentral.common.geocaching.api.LogOptions;
import geocentral.common.geocaching.api.PostLogException;
import geocentral.common.geocaching.api.PostLogResult;
import geocentral.common.map.CoordsUtils;
import geocentral.common.plugins.AsyncContext;
import geocentral.common.stats.GeocacheTypeCounter;
import geocentral.common.ws.LoginRequiredException;
import geocentral.common.ws.WsTaskInfo;
import geocentral.http.WebClientManager;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import okhttp3.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.parsers.ParseException;
import org.bacza.http.HttpResponseException;
import org.bacza.http.RequestUtils;
import org.bacza.http.URLUtils;
import org.bacza.http.WebClient;
import org.bacza.http.WebResponse;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.EnumUtils;
import org.bacza.utils.SimpleHtmlRenderer;
import org.bacza.utils.StringPair;
import org.bacza.utils.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class OkapiWebService
implements IGeocachingApi {
    private static final Log log = LogFactory.getLog(OkapiWebService.class);
    private static final OkapiGeocacheLogTypeMapper logTypeMapper = new OkapiGeocacheLogTypeMapper();
    private static final OkapiGeocacheLogTypeInputMapper logTypeInputMapper = new OkapiGeocacheLogTypeInputMapper();
    private final IInputGeocacheTypeMapper typeMapper = new OkapiGeocacheTypeMapper();
    private final IInputGeocacheSizeMapper sizeMapper = GeocacheMapperUtils.getSizeMapper();
    private final WebClient client;
    private final OAuthHelper helper;

    public OkapiWebService(UserProfile profile) {
        AssertUtils.notNull(profile, "profile");
        this.client = WebClientManager.getInstance().getClient(profile).newClient(new OkapiWebExecutor());
        this.helper = OAuthService.getInstance().getAuthHelper(this.getSite(), profile);
    }

    protected abstract String getBaseUrl();

    protected abstract LogOptions getLogOptions();

    @Override
    public void close() throws IOException {
    }

    protected String getUrl(String path) {
        return URLUtils.absAsString(this.getBaseUrl(), path);
    }

    protected WsTaskInfo getTaskInfo(String task) {
        return new WsTaskInfo(this.getSite().getSiteName(), task);
    }

    protected Request signRequest(Request req, WsTaskInfo info) throws IOException, LoginRequiredException {
        try {
            return this.helper.signRequest(req);
        }
        catch (OAuthConsumerException e) {
            this.helper.invalidate();
            throw new LoginRequiredException(info);
        }
    }

    @Override
    public boolean login(AsyncContext ctx, String username, String password) throws IOException, ParseException, LoginRequiredException {
        log.trace((Object)"Logging in...");
        try {
            return this.helper.login();
        }
        catch (OAuthConsumerException e) {
            WsTaskInfo info = new WsTaskInfo(this.getSite().getSiteName(), GeocachingTaskNames.TASK_LOGIN, GeocachingTaskNames.TASK_DETAILS_OAUTH_ERR);
            throw new LoginRequiredException(info);
        }
    }

    @Override
    public boolean logout(AsyncContext ctx) throws IOException, ParseException, LoginRequiredException {
        log.trace((Object)"Logging out...");
        this.helper.logout();
        return true;
    }

    @Override
    public GeocacheItem getGeocacheByCode(AsyncContext ctx, String code) throws IOException, LoginRequiredException {
        AssertUtils.notNull(ctx, "ctx");
        AssertUtils.notNull(code, "code");
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_GEOCACHE);
        String url = this.getUrl("/okapi/services/caches/geocache");
        LinkedList<StringPair> params = new LinkedList<StringPair>();
        params.add(new StringPair("cache_code", code));
        params.add(new StringPair("fields", "code|name|location|type|status|owner|hint2|size2|difficulty|terrain|recommendations|latest_logs|rating|rating_votes|req_passwd"));
        params.add(new StringPair("user_logs_only", "true"));
        params.add(new StringPair("lpc", "all"));
        Request req = RequestUtils.post(url, params);
        req = this.signRequest(req, info);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (WebResponse response = this.client.execute(req);){
                int votes;
                double rating;
                JSONArray logs;
                String data = response.getContentText();
                JSONObject json = new JSONObject(data);
                GeocacheItem gc = new GeocacheItem();
                gc.setCode(code);
                gc.setName(json.getString("name"));
                gc.setCoords(CoordsUtils.parseCoordsPipe(json.optString("location")));
                gc.setType((GeocacheType)((Object)this.typeMapper.getMappedValue(json.optString("type"))));
                gc.setSize((GeocacheSize)((Object)this.sizeMapper.getMappedValue(json.optString("size2"))));
                gc.setRatingDifficulty(json.optDouble("difficulty"));
                gc.setRatingTerrain(json.optDouble("terrain"));
                gc.setFavPoints(json.optInt("recommendations"));
                gc.setHint(json.optString("hint2"));
                JSONObject owner = json.optJSONObject("owner");
                if (owner != null) {
                    gc.setOwner(owner.optString("username"));
                }
                if ((logs = json.optJSONArray("latest_logs")) != null) {
                    int i = 0;
                    while (i < logs.length()) {
                        JSONObject log = logs.getJSONObject(i);
                        String logTypeStr = log.getString("type");
                        String logDateStr = log.getString("date");
                        GeocacheLogType logType = (GeocacheLogType)((Object)logTypeInputMapper.getMappedValue(logTypeStr));
                        Date logDate = DateUtils.parseDateIso8601(logDateStr);
                        AssertUtils.notNull(logDate, "Log Date");
                        if (logType != null && logDate != null) {
                            Date lastDate;
                            int lastRank = this.getLogTypeRank(gc.getExistingLogType());
                            int newRank = this.getLogTypeRank(logType);
                            if (newRank > 0 && newRank >= lastRank && ((lastDate = gc.getExistingLogDate()) == null || logDate.compareTo(lastDate) > 0)) {
                                gc.setExistingLogDate(logDate);
                                gc.setExistingLogType(logType);
                            }
                        }
                        ++i;
                    }
                }
                if ((rating = json.optDouble("rating", -1.0)) >= 0.0) {
                    gc.setRating(rating);
                }
                if ((votes = json.optInt("rating_votes", -1)) >= 0) {
                    gc.setRatingVotes(votes);
                }
                gc.setPasswordRequired(json.optBoolean("req_passwd"));
                return gc;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (HttpResponseException e) {
            if (e.isUnauthorized()) {
                this.helper.invalidate();
                throw new LoginRequiredException(info);
            }
            throw e;
        }
    }

    private int getLogTypeRank(GeocacheLogType logType) {
        if (logType != null) {
            switch (logType) {
                case DNF: {
                    return 1;
                }
                case WILL_ATTEND: {
                    return 1;
                }
                case FOUND_IT: {
                    return 2;
                }
                case ATTENDED: {
                    return 2;
                }
            }
        }
        return -1;
    }

    @Override
    public GeocacheItem getGeocacheByGuid(AsyncContext ctx, String guid) throws IOException, LoginRequiredException {
        AssertUtils.notNull(ctx, "ctx");
        AssertUtils.notNull(guid, "guid");
        GeocachingApiAssertUtils.notImplemented(this.getSite(), "getGeocacheByGuid");
        return null;
    }

    @Override
    public SiteProfile getUserInfo(AsyncContext ctx) throws IOException, ParseException, LoginRequiredException {
        AssertUtils.notNull(ctx, "ctx");
        log.trace((Object)"Getting user info...");
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_GET_USER_INFO);
        String url = this.getUrl("/okapi/services/users/user");
        LinkedList<StringPair> params = new LinkedList<StringPair>();
        params.add(new StringPair("fields", "username|uuid|internal_id"));
        Request req = RequestUtils.post(url, params);
        req = this.signRequest(req, info);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (WebResponse response = this.client.execute(req);){
                String data = response.getContentText();
                JSONObject json = new JSONObject(data);
                String login = json.optString("username", null);
                String id = json.optString("internal_id", null);
                String uuid = json.optString("uuid", null);
                SiteProfile profile = new SiteProfile(this.getSite(), id, uuid, login);
                profile.setType("basic");
                return profile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (HttpResponseException e) {
            if (e.isUnauthorized()) {
                this.helper.invalidate();
                throw new LoginRequiredException(info);
            }
            throw e;
        }
    }

    @Override
    public GeocacheTypeCounter getUserStats(IProgressMonitor monitor) throws IOException, LoginRequiredException {
        GeocachingApiAssertUtils.notImplemented(this.getSite(), "getUserStats");
        return null;
    }

    @Override
    public PostLogResult postLog(AsyncContext ctx, FieldNoteItem item) throws InvalidLogTypeException, IOException, ParseException, LoginRequiredException, PostLogException {
        int ratingInt;
        Double rating;
        AssertUtils.notNull(ctx, "ctx");
        AssertUtils.notNull(item, "item");
        WsTaskInfo info = this.getTaskInfo(GeocachingTaskNames.TASK_POST_LOG);
        String code = item.getGeocacheCode();
        AssertUtils.notEmpty(code, "Geocache code");
        GeocacheLogType logType = item.getLogType();
        AssertUtils.notNull((Object)logType, "Log type");
        String logTypeStr = (String)logTypeMapper.getMappedValue(logType);
        if (!StringUtils.notEmpty(logTypeStr)) {
            throw new InvalidLogTypeException(logType);
        }
        String logText = item.getLogTextFormatted();
        AssertUtils.notEmpty(logText, "Log text");
        SimpleHtmlRenderer renderer = new SimpleHtmlRenderer();
        String logTextHtml = renderer.render(logText);
        Date logDate = item.getLogDate();
        AssertUtils.notNull(logDate, "Log date");
        String logDateStr = DateUtils.formatDateGMT(logDate);
        String url = this.getUrl("/okapi/services/logs/submit");
        LinkedList<StringPair> params = new LinkedList<StringPair>();
        params.add(new StringPair("cache_code", code));
        params.add(new StringPair("logtype", logTypeStr));
        params.add(new StringPair("comment", logTextHtml));
        params.add(new StringPair("comment_format", "html"));
        params.add(new StringPair("when", logDateStr));
        params.add(new StringPair("on_duplicate", "continue"));
        if (item.getFavourite() && OkapiWebService.canUseRecommend(logType)) {
            params.add(new StringPair("recommend", "true"));
        }
        if (item.isPasswordRequired() && OkapiWebService.canUsePassword(logType)) {
            String password = StringUtils.nvl(item.getOptPassword());
            params.add(new StringPair("password", password));
        }
        if ((rating = item.getOptRating()) != null && OkapiWebService.canUseRating(logType) && (ratingInt = rating.intValue()) >= 1 && ratingInt <= 5) {
            params.add(new StringPair("rating", String.format("%d", ratingInt)));
        }
        Request req = RequestUtils.post(url, params);
        req = this.signRequest(req, info);
        try {
            Throwable throwable = null;
            Object var17_20 = null;
            try (WebResponse response = this.client.execute(req);){
                String data = response.getContentText();
                JSONObject json = new JSONObject(data);
                boolean success = json.optBoolean("success");
                String message = json.optString("message");
                String uuid = json.optString("log_uuid");
                if (success && StringUtils.notEmpty(uuid)) {
                    return new PostLogResult(PostLogResult.Status.POSTED, message, uuid);
                }
                if (StringUtils.isEmpty(message)) {
                    throw new PostLogException();
                }
                if (StringUtils.contains(message, "This cache requires a password")) {
                    throw new PostLogException("PASSWORD_REQUIRED");
                }
                if (StringUtils.contains(message, "Invalid password")) {
                    throw new PostLogException("PASSWORD_INVALID");
                }
                throw new PostLogException("UNKNOWN", message);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (HttpResponseException e) {
            if (e.isUnauthorized()) {
                this.helper.invalidate();
                throw new LoginRequiredException(info);
            }
            throw e;
        }
    }

    private static boolean canUseRecommend(GeocacheLogType logType) {
        return EnumUtils.equalsAny(logType, GeocacheLogType.FOUND_IT, GeocacheLogType.ATTENDED);
    }

    private static boolean canUsePassword(GeocacheLogType logType) {
        return EnumUtils.equalsAny(logType, GeocacheLogType.FOUND_IT);
    }

    private static boolean canUseRating(GeocacheLogType logType) {
        return EnumUtils.equalsAny(logType, GeocacheLogType.FOUND_IT);
    }
}

