/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.oauth;

import geocentral.api.oauth.OAuthConfig;
import geocentral.api.oauth.OAuthHelper;
import geocentral.app.Geocentral;
import geocentral.common.app.ConfigDataService;
import geocentral.common.app.IConfigData;
import geocentral.common.app.UserProfile;
import geocentral.common.geocaching.GeocacheSite;
import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.EnumUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public final class OAuthService {
    private static final OAuthService instance = new OAuthService();
    private final Map<GeocacheSite, OAuthConfig> configsBySite = new HashMap<GeocacheSite, OAuthConfig>();
    private final Map<String, OAuthHelper> helpers = new HashMap<String, OAuthHelper>();

    public static OAuthService getInstance() {
        return instance;
    }

    private OAuthService() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        IConfigData data;
        IConfigData iConfigData = data = ConfigDataService.getInstance().getResourceData(Geocentral.class, "/system/system-data-1.dat", true);
        synchronized (iConfigData) {
            JSONObject root = data.getObject("config");
            JSONArray sites = root.optJSONArray("sites");
            int max = sites != null ? sites.length() : 0;
            int i = 0;
            while (i < max) {
                JSONObject s = sites.getJSONObject(i);
                try {
                    GeocacheSite site = EnumUtils.getEnum(GeocacheSite.class, s.optString("site", null));
                    String consumerKey = s.optString("consumerKey", null);
                    String consumerSecret = s.optString("consumerSecret", null);
                    String requestTokenUrl = s.optString("requestTokenUrl", null);
                    String accessTokenUrl = s.optString("accessTokenUrl", null);
                    String authorizationUrl = s.optString("authorizationUrl", null);
                    String callbackUrl = s.optString("callbackUrl", null);
                    OAuthConfig config = new OAuthConfig(site, consumerKey, consumerSecret, requestTokenUrl, accessTokenUrl, authorizationUrl, callbackUrl);
                    this.registerConfig(config);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private synchronized void registerConfig(OAuthConfig config) {
        AssertUtils.notNull(config, "config");
        AssertUtils.notNull((Object)config.site, "config site");
        this.configsBySite.put(config.site, config);
    }

    private String getHelperId(GeocacheSite site, UserProfile profile) {
        return String.format("%s::%s", site.toString(), profile.getUUID());
    }

    public synchronized OAuthHelper getAuthHelper(GeocacheSite site, UserProfile profile) {
        AssertUtils.notNull((Object)site, "site");
        AssertUtils.notNull(profile, "profile");
        String id = this.getHelperId(site, profile);
        OAuthHelper helper = this.helpers.get(id);
        if (helper == null) {
            OAuthConfig config = this.configsBySite.get((Object)site);
            AssertUtils.checkState(config != null, "Missing OAuth config for site: " + site.getSiteName());
            helper = new OAuthHelper(config, profile);
            this.helpers.put(id, helper);
        }
        return helper;
    }
}

