/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.xml;

import geocentral.api.groundspeak.xml.GeocacheLogsParser;
import geocentral.common.data.DataReaderContext;
import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.geocaching.GeocacheMapperUtils;
import geocentral.common.geocaching.GeocacheSize;
import geocentral.common.geocaching.GeocacheType;
import geocentral.common.geocaching.GeocachingItemFactoryUtils;
import geocentral.common.geocaching.RatingUtils;
import geocentral.common.items.Geocache;
import geocentral.common.items.GeocacheUser;
import geocentral.common.items.WaypointItem;
import org.bacza.utils.AssertUtils;

public class GeocacheParser
extends UserParser {
    private Geocache geocache;

    public GeocacheParser(DataReaderContext readerContext) {
        super(readerContext);
    }

    @Override
    public void startProcessing() {
        AssertUtils.checkState(this.readerContext.peekItem() instanceof WaypointItem, "Invalid parser state");
        WaypointItem wpt = (WaypointItem)this.readerContext.popItem();
        String site = GeocachingItemFactoryUtils.getSiteByGeocacheCode(wpt.getName());
        this.geocache = GeocachingItemFactoryUtils.createGeocache(site);
        AssertUtils.checkState(this.geocache != null, "Unknown site");
        this.geocache.initialize(wpt);
        this.geocache.setSrcId(this.getCurrentElementAttrs().getAttributeValue("id"));
        this.readerContext.pushItem(this.geocache);
    }

    @Override
    public void stopProcessing() {
        if (this.geocache == this.readerContext.popItem()) {
            this.readerContext.getDataStore().putItem(this.geocache);
        }
    }

    @Override
    public void startElement(String name, String namespace, String uri, IAttributes attrs) {
        if ("logs".equals(name)) {
            this.installParser(new GeocacheLogsParser(this.readerContext));
        }
    }

    @Override
    public void value(String name, Object value, IAttributes attrs) {
        if ("name".equals(name)) {
            this.geocache.setName(GeocacheParser.getValueAsString(value));
        } else if ("owner".equals(name)) {
            GeocacheUser owner = GeocachingItemFactoryUtils.createGeocacheUser(this.geocache.getSite());
            AssertUtils.checkState(owner != null, "Unknown site");
            owner.setSrcId(this.getCurrentElementAttrs().getAttributeValue("id"));
            owner.setUsername(GeocacheParser.getValueAsString(value));
            this.geocache.setOwner(owner);
        } else if ("type".equals(name)) {
            this.geocache.setType((GeocacheType)((Object)GeocacheMapperUtils.getTypeMapper().getMappedValue(GeocacheParser.getValueAsString(value))));
        } else if ("difficulty".equals(name)) {
            this.geocache.setRatingDifficulty(RatingUtils.valueOf(value));
        } else if ("terrain".equals(name)) {
            this.geocache.setRatingTerrain(RatingUtils.valueOf(value));
        } else if ("container".equals(name)) {
            this.geocache.setSize((GeocacheSize)((Object)GeocacheMapperUtils.getSizeMapper().getMappedValue(GeocacheParser.getValueAsString(value))));
        } else if ("country".equals(name)) {
            this.geocache.setCountry(GeocacheParser.getValueAsString(value));
        } else if ("state".equals(name)) {
            this.geocache.setState(GeocacheParser.getValueAsString(value));
        } else if ("long_description".equals(name)) {
            this.geocache.setDescription(GeocacheParser.getValueAsString(value));
        } else if ("encoded_hints".equals(name)) {
            this.geocache.setHint(GeocacheParser.getValueAsString(value));
        }
    }
}

