/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.xml;

import geocentral.common.data.DataReaderContext;
import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.geocaching.GeocachingItemFactoryUtils;
import geocentral.common.items.Geocache;
import geocentral.common.items.GeocacheLog;
import geocentral.common.items.GeocacheUser;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;

public class GeocacheLogParser
extends UserParser {
    private Geocache geocache;
    private GeocacheLog log;

    public GeocacheLogParser(DataReaderContext readerContext) {
        super(readerContext);
    }

    @Override
    public void startProcessing() {
        AssertUtils.checkState(this.readerContext.peekItem() instanceof Geocache, "Invalid parser state");
        this.geocache = (Geocache)this.readerContext.peekItem();
        this.log = GeocachingItemFactoryUtils.createGeocacheLog(this.geocache.getSite());
        AssertUtils.checkState(this.log != null, "Unknown site");
        this.log.setSrcId(this.getCurrentElementAttrs().getAttributeValue("id"));
        this.log.setGeocache(this.geocache);
    }

    @Override
    public void stopProcessing() {
        if (this.geocache != null) {
            this.geocache.addLog(this.log);
        }
    }

    @Override
    public void value(String name, Object value, IAttributes attrs) {
        if ("type".equals(name)) {
            this.log.setType(GeocacheLogParser.getValueAsString(value));
        } else if ("date".equals(name)) {
            this.log.setDate(DateUtils.parseDateIso8601(GeocacheLogParser.getValueAsString(value)));
        } else if ("finder".equals(name)) {
            GeocacheUser owner = GeocachingItemFactoryUtils.createGeocacheUser(this.geocache.getSite());
            AssertUtils.checkState(owner != null, "Unknown site");
            owner.setSrcId(this.getCurrentElementAttrs().getAttributeValue("id"));
            owner.setUsername(GeocacheLogParser.getValueAsString(value));
            this.log.setUser(owner);
        } else if ("text".equals(name)) {
            this.log.setText(GeocacheLogParser.getValueAsString(value));
        }
    }
}

