/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui.actions;

import geocentral.api.groundspeak.ui.actions.SaveFieldNotesArgs;
import geocentral.common.plugins.AbstractAsyncAction;
import geocentral.common.plugins.IConcurrencyContext;
import geocentral.common.sql.ConnectionManager;
import geocentral.common.sql.FieldNoteItemDAO;
import geocentral.common.sql.FieldNoteItemDAOManager;
import geocentral.common.sys.SysDocMetaUtils;
import geocentral.common.ui.DialogUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;

public class SaveFieldNotesAction
extends AbstractAsyncAction {
    private static final Log log = LogFactory.getLog(SaveFieldNotesAction.class);
    private static final String TASK_NAME = "Zapisywanie notatek terenowych";
    private SaveFieldNotesArgs args;

    public SaveFieldNotesAction(SaveFieldNotesArgs args) {
        this.args = args;
    }

    @Override
    public String getTaskName() {
        return TASK_NAME;
    }

    @Override
    public IConcurrencyContext getConcurrencyContext() {
        return null;
    }

    @Override
    public void execute() {
        this.getAsyncContext().getMonitor().beginTask(TASK_NAME, -1);
        this.getAsyncContext().getMonitor().subTask(this.args.filename);
        String daoVer = "v1.5";
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Connection conn = this.getConnection();){
                    SysDocMetaUtils.init(conn, "geocentral.document.field_notes", "v1.5");
                    FieldNoteItemDAO dao = (FieldNoteItemDAO)FieldNoteItemDAOManager.getInstance().createDAO("v1.5", conn);
                    AssertUtils.notNull(dao, "DAO");
                    dao.dropSchema();
                    dao.createSchema();
                    dao.insert(this.args.items);
                    conn.commit();
                    conn.setAutoCommit(true);
                    dao.cleanupSchema();
                    this.args.model.setFilename(this.args.filename);
                    this.args.model.setDirty(false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.debug((Object)"Error", (Throwable)e);
                this.getAsyncContext().getMonitor().done();
                DialogUtils.showError(String.format("B\u0142\u0105d polecenia SQL: %s", e.getMessage()));
                this.getAsyncContext().getMonitor().done();
            }
        }
        finally {
            this.getAsyncContext().getMonitor().done();
        }
    }

    protected Connection getConnection() throws SQLException {
        return ConnectionManager.getInstance().getConnection(this.args.filename, true);
    }
}

