/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui.actions;

import geocentral.common.app.StorageService;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.bacza.utils.DateUtils;
import org.bacza.utils.FileUtils;
import org.bacza.utils.StringUtils;

public class PostFieldNotesLogger
implements Closeable {
    private static final String LOG_PATH = StorageService.getInstance().getLogsPath("fieldnotes");
    private static final String LOG_DELIM = "------------------------------------------------------------------------------------------";
    private String filename = null;
    private OutputStreamWriter writer = null;

    public PostFieldNotesLogger(boolean enabled) throws IOException {
        if (enabled) {
            String timestamp = DateUtils.formatDate(new Date(), "yyyyMMdd-HHmmss");
            this.filename = FileUtils.combinePath(LOG_PATH, String.format("log-%s.txt", timestamp));
            File file = new File(this.filename);
            FileUtils.mkdirs(file.getParentFile());
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        }
    }

    public void writeDelim() throws IOException {
        this.writeLine(LOG_DELIM);
    }

    public void writeLine() throws IOException {
        this.writeLine("");
    }

    public void writeLine(String data) throws IOException {
        if (this.writer != null) {
            this.writer.write(data);
            this.writer.write(StringUtils.NEW_LINE);
        }
    }

    public boolean isEnabled() {
        return this.filename != null;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }
}

