/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui.actions;

import geocentral.common.Messages;
import geocentral.common.data.FieldNoteDataModel;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.plugins.AbstractAsyncAction;
import geocentral.common.plugins.IConcurrencyContext;
import geocentral.common.sql.ConnectionManager;
import geocentral.common.sql.FieldNoteItemDAO;
import geocentral.common.sql.FieldNoteItemDAOManager;
import geocentral.common.sys.SysDocMetaItem;
import geocentral.common.sys.SysDocMetaUtils;
import geocentral.common.ui.DialogUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.IOUtils;
import org.bacza.utils.StringUtils;

public class OpenFieldNotesAction
extends AbstractAsyncAction {
    private static final Log log = LogFactory.getLog(OpenFieldNotesAction.class);
    private List<FieldNoteItem> items;
    private String filename;
    public FieldNoteDataModel model;

    public OpenFieldNotesAction(List<FieldNoteItem> items, String filename, FieldNoteDataModel model) {
        this.items = items;
        this.filename = filename;
        this.model = model;
    }

    @Override
    public String getTaskName() {
        return Messages.getString("OpenFieldNotesAction.taskName");
    }

    @Override
    public IConcurrencyContext getConcurrencyContext() {
        return null;
    }

    @Override
    public void execute() {
        this.getAsyncContext().getMonitor().beginTask(this.getTaskName(), -1);
        this.getAsyncContext().getMonitor().subTask(this.filename);
        this.items.clear();
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (conn == null) {
                return;
            }
            try {
                String daoVer = this.getDAOVersion(conn);
                FieldNoteItemDAO fieldDao = (FieldNoteItemDAO)FieldNoteItemDAOManager.getInstance().createDAO(daoVer, conn);
                AssertUtils.checkState(fieldDao != null, Messages.getString("OpenFieldNotesAction.unsupportedFileFormat"));
                List newItems = fieldDao.select();
                conn.close();
                this.items.addAll(newItems);
                this.model.setFilename(this.filename);
                this.model.setDirty(false);
            }
            catch (SQLException e) {
                log.debug((Object)"Error", (Throwable)e);
                this.getAsyncContext().getMonitor().done();
                DialogUtils.showError(String.format(Messages.getString("OpenFieldNotesAction.sqlError"), e.getMessage()));
            }
        }
        finally {
            this.getAsyncContext().getMonitor().done();
            IOUtils.close(conn);
        }
    }

    protected Connection getConnection() {
        try {
            return ConnectionManager.getInstance().getConnection(this.filename);
        }
        catch (SQLException e) {
            return null;
        }
    }

    protected String getDAOVersion(Connection conn) {
        String result = null;
        SysDocMetaItem meta = SysDocMetaUtils.selectFirst(conn);
        if (meta != null) {
            result = meta.getDocTypeVer();
        }
        return StringUtils.nvl(result, "v1.0");
    }
}

