/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui.actions;

import geocentral.api.groundspeak.GcWebService;
import geocentral.common.Messages;
import geocentral.common.app.UserProfile;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteType;
import geocentral.common.data.GeocacheItem;
import geocentral.common.fieldnotes.FieldNoteImportUtils;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.plugins.AbstractAsyncAction;
import geocentral.common.plugins.IConcurrencyContext;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.MessageUtils;
import geocentral.common.ws.LoginRequiredException;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;

public class CreateFieldNotesAction
extends AbstractAsyncAction {
    private static final Log log = LogFactory.getLog(CreateFieldNotesAction.class);
    private final UserProfile profile;
    private List<FieldNoteItem> items;

    public CreateFieldNotesAction(UserProfile profile, List<FieldNoteItem> items) {
        AssertUtils.notNull(profile, "profile");
        this.profile = profile;
        this.items = items;
    }

    @Override
    public String getTaskName() {
        return Messages.getString("CreateFieldNotesAction.taskName");
    }

    @Override
    public IConcurrencyContext getConcurrencyContext() {
        return null;
    }

    @Override
    public void execute() {
        log.debug((Object)"Creating field notes...");
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (GcWebService ws = new GcWebService(this.profile);){
                this.getAsyncContext().getMonitor().beginTask(Messages.getString("CreateFieldNotesAction.gettingOwnGeocaches"), -1);
                this.items.clear();
                List<GeocacheItem> geocaches = ws.getMyCaches(this.getAsyncContext());
                int countEvents = 0;
                if (geocaches != null) {
                    LinkedList<FieldNoteItem> newItems = new LinkedList<FieldNoteItem>();
                    for (GeocacheItem gc : geocaches) {
                        if (gc.getType() != null && gc.getType().isEvent()) {
                            ++countEvents;
                            continue;
                        }
                        FieldNoteItem meta = new FieldNoteItem();
                        meta.setFieldNoteType(FieldNoteType.FILE);
                        meta.setSite(GeocacheSite.GC);
                        meta.setType(gc.getType());
                        meta.setGeocacheCode(gc.getCode());
                        meta.setGeocacheName(gc.getName());
                        meta.setGeocacheOwner(gc.getOwner());
                        meta.setLogDate(new Date());
                        meta.setLogType(GeocacheLogType.WRITE_NOTE);
                        newItems.add(meta);
                    }
                    this.items.addAll(newItems);
                    if (newItems.size() > 0) {
                        DialogUtils.showInfo(String.format(Messages.getString("CreateFieldNotesAction.fieldNotesCreated"), newItems.size()));
                    } else {
                        DialogUtils.showWarning(Messages.getString("CreateFieldNotesAction.noFieldNotesCreated"));
                    }
                    if (countEvents > 0) {
                        DialogUtils.showInfo(String.format(Messages.getString("CreateFieldNotesAction.eventsSkipped"), countEvents));
                    }
                    FieldNoteImportUtils.deduplicateFieldNotes(this.items);
                    FieldNoteImportUtils.handleOptions(newItems);
                }
                log.debug((Object)"Creating field notes done.");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Error", (Throwable)e);
            MessageUtils.showIOException(e);
        }
        catch (LoginRequiredException e) {
            log.debug((Object)"Error", (Throwable)e);
            this.profile.removeSiteProfile(GeocacheSite.GC);
            MessageUtils.showLoginRequiredError(e);
        }
    }
}

