/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swt.DefaultEventTableViewer;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import ca.odell.glazedlists.swt.TableComparatorChooser;
import ca.odell.glazedlists.swt.TableItemConfigurer;
import ca.odell.glazedlists.swt.TextWidgetMatcherEditor;
import geocentral.api.groundspeak.GcWebService;
import geocentral.api.groundspeak.ui.EditFieldNoteDialog;
import geocentral.api.groundspeak.ui.EditFieldNotePasswordDialog;
import geocentral.api.groundspeak.ui.EditFieldNoteRatingDialog;
import geocentral.api.groundspeak.ui.EditFieldNoteTagDialog;
import geocentral.api.groundspeak.ui.FieldNoteItemComparator;
import geocentral.api.groundspeak.ui.FieldNoteItemTableFormat;
import geocentral.api.groundspeak.ui.FieldNoteItemTextFilterator;
import geocentral.api.groundspeak.ui.FieldNoteOptionsHelper;
import geocentral.api.groundspeak.ui.FieldNotesTableViewUtils;
import geocentral.api.groundspeak.ui.FieldNotesViewConfigActions;
import geocentral.api.groundspeak.ui.actions.CreateFieldNotesAction;
import geocentral.api.groundspeak.ui.actions.GetFieldNotesAction;
import geocentral.api.groundspeak.ui.actions.GetGeocacheAction;
import geocentral.api.groundspeak.ui.actions.OpenFieldNotesAction;
import geocentral.api.groundspeak.ui.actions.PostFieldNotesAction;
import geocentral.api.groundspeak.ui.actions.SaveFieldNotesAction;
import geocentral.api.groundspeak.ui.actions.SaveFieldNotesArgs;
import geocentral.api.groundspeak.ui.actions.TestFieldNotesAction;
import geocentral.api.opencaching.OpencachingUtils;
import geocentral.common.Messages;
import geocentral.common.app.ConfigManager;
import geocentral.common.app.UserProfile;
import geocentral.common.app.UserProfileService;
import geocentral.common.data.FieldNoteDataModel;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteItemIterator;
import geocentral.common.fieldnotes.FieldNoteChecker;
import geocentral.common.fieldnotes.FieldNotesClipboardUtils;
import geocentral.common.fieldnotes.FieldNotesPrefUtils;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.plugins.PluginExecutor;
import geocentral.common.scripting.ScriptingManager;
import geocentral.common.ui.CustomDrawingSupport;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.DisplayUtils;
import geocentral.common.ui.FileDialogUtils;
import geocentral.common.ui.dialogs.EditLogDateDialog;
import geocentral.common.ui.preferences.PreferenceStoreManager;
import geocentral.ui.views.IConfigurableTableView;
import geocentral.ui.views.IMenuItemProvider;
import geocentral.ui.views.TableViewConfig;
import geocentral.ui.views.View;
import geocentral.ui.views.ViewActionArgs;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.DesktopUtils;
import org.bacza.utils.StringUtils;
import org.bacza.utils.ThreadUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class FieldNotesView
extends View
implements IMenuItemProvider,
IConfigurableTableView {
    private static final Log log = LogFactory.getLog(FieldNotesView.class);
    private final FieldNoteDataModel model = new FieldNoteDataModel();
    private final IPropertyChangeListener preferenceListener;
    private final EventList<FieldNoteItem> baseList = this.model.getList();
    private final ObservableElementList<FieldNoteItem> observedList;
    private final SortedList<FieldNoteItem> sortedList;
    private final FilterList<FieldNoteItem> filteredList;
    private final EventList<FieldNoteItem> threadProxyList;
    private final CustomDrawingSupport customDrawingSupport;
    private Text filterText;
    private DefaultEventTableViewer<FieldNoteItem> tableViewer;
    private final StatusLineContributionItem statusItem1;
    private final StatusLineContributionItem statusItem2;
    private Action getFieldNotesAction;
    private Action createFieldNotesAction;
    private Action checkStatusAction;
    private Action openListingAction;
    private Action editAction;
    private Action editTagAction;
    private Action editRatingAction;
    private Action editPasswordAction;
    private Action favYesAction;
    private Action favNoAction;
    private Action visitYesAction;
    private Action visitNoAction;
    private Action logDateAction;
    private Action logTypeFoundAction;
    private Action logTypeDnfAction;
    private Action logTypeWriteNoteAction;
    private Action logTypeWillAttendAction;
    private Action logTypeAttendedAction;
    private Action logTypeNeedsMaintAction;
    private Action logTypeNeedsArchAction;
    private Action logTypeOwnerMaintAction;
    private Action logTypeDisableListingAction;
    private Action logTypeEnableListingAction;
    private Action postAction;
    private Action postTestAction;
    private final FieldNotesViewConfigActions viewConfigActions;
    private final PropertyChangeListener scriptingManagerListener;
    private boolean viewRatingModeChecked;
    private boolean viewSizeModeChecked;
    private MenuManager tableMenuManager;

    public FieldNotesView() {
        ObservableElementList.Connector connector = GlazedLists.beanConnector(FieldNoteItem.class);
        this.observedList = new ObservableElementList(this.baseList, connector);
        this.sortedList = new SortedList(this.observedList, (Comparator)new FieldNoteItemComparator());
        this.filteredList = new FilterList(this.sortedList);
        this.threadProxyList = GlazedListsSWT.swtThreadProxyList(this.filteredList, (Display)DisplayUtils.getDisplay());
        this.customDrawingSupport = new CustomDrawingSupport();
        this.statusItem1 = new StatusLineContributionItem("geocentral.status.table.items", 20);
        this.statusItem2 = new StatusLineContributionItem("geocentral.status.table.filter", 20);
        this.updateStatusLine();
        this.threadProxyList.addListEventListener((ListEventListener)new ListEventListener<FieldNoteItem>(){

            public void listChanged(ListEvent<FieldNoteItem> listChanges) {
                FieldNotesView.this.updateStatusLine();
            }
        });
        this.observedList.addListEventListener((ListEventListener)new ListEventListener<FieldNoteItem>(){

            public void listChanged(ListEvent<FieldNoteItem> listChanges) {
                FieldNotesView.this.model.setDirty(true);
            }
        });
        this.viewRatingModeChecked = PreferenceStoreManager.getStore().getBoolean("geocentral.preferences.fieldnotes.rating_as_image");
        this.viewSizeModeChecked = PreferenceStoreManager.getStore().getBoolean("geocentral.preferences.fieldnotes.size_as_image");
        this.createActions();
        this.createMenus();
        this.viewConfigActions = new FieldNotesViewConfigActions(this, "geocentral.document.FieldNotes");
        String viewId = ConfigManager.getInstance().getString("geocentral.fieldnotes.menu.view.configId");
        if (viewId != null) {
            this.viewConfigActions.setCurrentId(viewId);
        }
        this.scriptingManagerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(java.beans.PropertyChangeEvent event) {
                FieldNotesView.this.viewConfigActions.reload();
            }
        };
        ScriptingManager.getInstance().addPropertyChangeListener(this.scriptingManagerListener);
        this.preferenceListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                log.trace((Object)("Preference changed: " + property));
                if ("geocentral.preferences.general.date_format".equals(property)) {
                    FieldNotesView.this.changeTableColumns(FieldNotesView.this.viewConfigActions.getCurrentConfig());
                }
                if ("geocentral.preferences.fieldnotes.rating_as_image".equals(property)) {
                    FieldNotesView.this.viewRatingModeChecked = (Boolean)event.getNewValue();
                    FieldNotesView.this.changeTableColumns(FieldNotesView.this.viewConfigActions.getCurrentConfig());
                }
                if ("geocentral.preferences.fieldnotes.size_as_image".equals(property)) {
                    FieldNotesView.this.viewSizeModeChecked = (Boolean)event.getNewValue();
                    FieldNotesView.this.changeTableColumns(FieldNotesView.this.viewConfigActions.getCurrentConfig());
                }
            }
        };
    }

    private void updateStatusLine() {
        int baseSize = this.baseList.size();
        int filteredSize = this.filteredList.size();
        this.statusItem1.setText(String.format(Messages.getString("FieldNotesView.status.items"), filteredSize));
        if (baseSize == filteredSize) {
            this.statusItem2.setText(" ");
        } else {
            this.statusItem2.setText(Messages.getString("FieldNotesView.status.filterEnabled"));
        }
    }

    public FieldNoteDataModel getDataModel() {
        return this.model;
    }

    @Override
    public Control createControl(CTabItem tabItem) {
        Composite composite = new Composite((Composite)tabItem.getParent(), 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createView(composite, tabItem);
        return composite;
    }

    private ImageDescriptor createImageDescriptor(String filename) {
        return ImageDescriptor.createFromFile(FieldNotesView.class, (String)filename);
    }

    private void createActions() {
        this.getFieldNotesAction = new Action(Messages.getString("FieldNotesView.action.downloadFieldNotes")){

            public void run() {
                FieldNotesView.this.onDownloadFieldNotes();
            }
        };
        this.createFieldNotesAction = new Action(Messages.getString("FieldNotesView.action.createFieldNotes")){

            public void run() {
                FieldNotesView.this.onCreateFieldNotes();
            }
        };
        this.checkStatusAction = new Action(Messages.getString("FieldNotesView.action.checkStatus"), this.createImageDescriptor("/icons/tick.png")){

            public void run() {
                FieldNotesView.this.onCheckStatus();
            }
        };
        this.openListingAction = new Action(Messages.getString("FieldNotesView.action.openListing")){

            public void run() {
                FieldNotesView.this.onListing();
            }
        };
        this.editAction = new Action(Messages.getString("FieldNotesView.action.editComment"), this.createImageDescriptor("/icons/pencil.png")){

            public void run() {
                FieldNotesView.this.onEdit();
            }
        };
        this.editTagAction = new Action(Messages.getString("FieldNotesView.action.editTag")){

            public void run() {
                FieldNotesView.this.onEditTag();
            }
        };
        this.editRatingAction = new Action(Messages.getString("FieldNotesView.action.editRating")){

            public void run() {
                FieldNotesView.this.onEditRating();
            }
        };
        this.editPasswordAction = new Action(Messages.getString("FieldNotesView.action.editPassword")){

            public void run() {
                FieldNotesView.this.onEditPassword();
            }
        };
        this.favYesAction = new Action(Messages.getString("FieldNotesView.action.favYes"), this.createImageDescriptor("/icons/star.png")){

            public void run() {
                FieldNotesView.this.onFavorites(true);
            }
        };
        this.favNoAction = new Action(Messages.getString("FieldNotesView.action.favNo")){

            public void run() {
                FieldNotesView.this.onFavorites(false);
            }
        };
        this.visitYesAction = new Action(Messages.getString("FieldNotesView.action.visitYes"), this.createImageDescriptor("/icons/bug.png")){

            public void run() {
                FieldNotesView.this.onVisit(true);
            }
        };
        this.visitNoAction = new Action(Messages.getString("FieldNotesView.action.visitNo")){

            public void run() {
                FieldNotesView.this.onVisit(false);
            }
        };
        this.logDateAction = new Action(Messages.getString("FieldNotesView.action.editLogDate")){

            public void run() {
                FieldNotesView.this.onLogDate();
            }
        };
        this.logTypeFoundAction = new Action(GeocacheLogType.FOUND_IT.text(), this.createImageDescriptor("/icons/emoticon_smile.png")){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.FOUND_IT);
            }
        };
        this.logTypeDnfAction = new Action(GeocacheLogType.DNF.text()){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.DNF);
            }
        };
        this.logTypeWriteNoteAction = new Action(GeocacheLogType.WRITE_NOTE.text()){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.WRITE_NOTE);
            }
        };
        this.logTypeWillAttendAction = new Action(GeocacheLogType.WILL_ATTEND.text()){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.WILL_ATTEND);
            }
        };
        this.logTypeAttendedAction = new Action(GeocacheLogType.ATTENDED.text(), this.createImageDescriptor("/icons/comment.png")){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.ATTENDED);
            }
        };
        this.logTypeNeedsMaintAction = new Action(GeocacheLogType.NEEDS_MAINT.text()){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.NEEDS_MAINT);
            }
        };
        this.logTypeNeedsArchAction = new Action(GeocacheLogType.NEEDS_ARCH.text()){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.NEEDS_ARCH);
            }
        };
        this.logTypeOwnerMaintAction = new Action(GeocacheLogType.OWNER_MAINT.text()){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.OWNER_MAINT);
            }
        };
        this.logTypeDisableListingAction = new Action(GeocacheLogType.DISABLE_LISTING.text(), this.createImageDescriptor("/icons/minus.png")){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.DISABLE_LISTING);
            }
        };
        this.logTypeEnableListingAction = new Action(GeocacheLogType.ENABLE_LISTING.text(), this.createImageDescriptor("/icons/check.png")){

            public void run() {
                FieldNotesView.this.onLogType(GeocacheLogType.ENABLE_LISTING);
            }
        };
        this.postAction = new Action(Messages.getString("FieldNotesView.action.postLogs"), this.createImageDescriptor("/icons/control_play_blue.png")){

            public void run() {
                FieldNotesView.this.onPost(false);
            }
        };
        this.postTestAction = new Action(Messages.getString("FieldNotesView.action.postLogsTest")){

            public void run() {
                FieldNotesView.this.onPost(true);
            }
        };
    }

    private void createMenus() {
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                FieldNotesView.this.initMenuFieldNotes(menu, false);
            }
        });
        this.tableMenuManager = menu;
    }

    @Override
    public void setFocus() {
        this.filterText.setFocus();
    }

    @Override
    public void activated() {
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void closed() {
        ScriptingManager.getInstance().removePropertyChangeListener(this.scriptingManagerListener);
        PreferenceStoreManager.getStore().removePropertyChangeListener(this.preferenceListener);
    }

    @Override
    public MenuManager getMenuManager() {
        MenuManager menu = new MenuManager(Messages.getString("FieldNotesView.action.fieldNotes"), "geocentral.menu.fieldnotes");
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                FieldNotesView.this.initMenuFieldNotes(menu, true);
            }
        });
        return menu;
    }

    protected void initMenuFieldNotes(IMenuManager menu, boolean mainMenu) {
        if (mainMenu) {
            menu.add((IAction)this.getFieldNotesAction);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.checkStatusAction);
        menu.add((IAction)this.openListingAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editAction);
        menu.add((IAction)this.editTagAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editRatingAction);
        menu.add((IAction)this.editPasswordAction);
        menu.add((IContributionItem)new Separator());
        MenuManager favMenu = new MenuManager(Messages.getString("FieldNotesView.action.editFav"));
        favMenu.add((IAction)this.favYesAction);
        favMenu.add((IAction)this.favNoAction);
        menu.add((IContributionItem)favMenu);
        MenuManager visitMenu = new MenuManager(Messages.getString("FieldNotesView.action.editVisit"));
        visitMenu.add((IAction)this.visitYesAction);
        visitMenu.add((IAction)this.visitNoAction);
        menu.add((IContributionItem)visitMenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.logDateAction);
        MenuManager logTypeMenu = new MenuManager(Messages.getString("FieldNotesView.action.editLogType"));
        logTypeMenu.add((IAction)this.logTypeFoundAction);
        logTypeMenu.add((IAction)this.logTypeDnfAction);
        logTypeMenu.add((IAction)this.logTypeWriteNoteAction);
        logTypeMenu.add((IContributionItem)new Separator());
        logTypeMenu.add((IAction)this.logTypeWillAttendAction);
        logTypeMenu.add((IAction)this.logTypeAttendedAction);
        logTypeMenu.add((IContributionItem)new Separator());
        logTypeMenu.add((IAction)this.logTypeNeedsMaintAction);
        logTypeMenu.add((IAction)this.logTypeNeedsArchAction);
        logTypeMenu.add((IContributionItem)new Separator());
        logTypeMenu.add((IAction)this.logTypeDisableListingAction);
        logTypeMenu.add((IAction)this.logTypeOwnerMaintAction);
        logTypeMenu.add((IAction)this.logTypeEnableListingAction);
        menu.add((IContributionItem)logTypeMenu);
        if (mainMenu) {
            menu.add((IContributionItem)new Separator());
            MenuManager advancedMenu = new MenuManager(Messages.getString("FieldNotesView.action.advanced"));
            advancedMenu.add((IAction)this.createFieldNotesAction);
            menu.add((IContributionItem)advancedMenu);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.postAction);
        if (FieldNotesPrefUtils.isTestingEnabled()) {
            menu.add((IAction)this.postTestAction);
        }
    }

    @Override
    public void addStatusLineContributions(StatusLineManager manager) {
        manager.appendToGroup("BEGIN_GROUP", (IContributionItem)this.statusItem1);
        manager.appendToGroup("BEGIN_GROUP", (IContributionItem)this.statusItem2);
    }

    private void createView(Composite parent, CTabItem tabItem) {
        this.filterText = new Text(parent, 128);
        GridData gridData = new GridData(768);
        this.filterText.setLayoutData((Object)gridData);
        this.filterText.setMessage(Messages.getString("FieldNotesView.filterText"));
        Table table = new Table(parent, 268503810);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createMouseListener(table);
        this.createMenu(table);
        TextWidgetMatcherEditor matcher = new TextWidgetMatcherEditor(this.filterText, (TextFilterator)new FieldNoteItemTextFilterator());
        this.filteredList.setMatcherEditor((MatcherEditor)matcher);
        FieldNoteItemTableFormat tf = new FieldNoteItemTableFormat(this.configureTableViewConfig(this.viewConfigActions.getCurrentConfig()));
        this.customDrawingSupport.setConfigurer(tf);
        this.tableViewer = GlazedListsSWT.eventTableViewer(this.threadProxyList, (Table)table, (TableFormat)tf, (TableItemConfigurer)tf);
        TableComparatorChooser tableSorter = TableComparatorChooser.install(this.tableViewer, this.sortedList, (boolean)false);
        PreferenceStoreManager.getStore().addPropertyChangeListener(this.preferenceListener);
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                FieldNotesView.this.customDrawingSupport.handleEventEraseItem(event);
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                FieldNotesView.this.customDrawingSupport.handleEventPaintItem(event);
            }
        });
    }

    protected TableViewConfig configureTableViewConfig(TableViewConfig config) {
        FieldNotesTableViewUtils.configureRatingMode(config, this.viewRatingModeChecked);
        FieldNotesTableViewUtils.configureSizeMode(config, this.viewSizeModeChecked);
        return config;
    }

    @Override
    public void changeTableColumns(TableViewConfig config) {
        if (config != null) {
            this.changeTableFormat(new FieldNoteItemTableFormat(this.configureTableViewConfig(config)));
        }
    }

    protected void changeTableFormat(FieldNoteItemTableFormat tf) {
        this.customDrawingSupport.setConfigurer(tf);
        this.tableViewer.setTableFormat((TableFormat)tf);
        this.tableViewer.setTableItemConfigurer((TableItemConfigurer)tf);
        TableComparatorChooser tableSorter = TableComparatorChooser.install(this.tableViewer, this.sortedList, (boolean)false);
    }

    private void createMouseListener(Table table) {
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                FieldNotesView.this.onEdit();
            }
        });
    }

    private void createMenu(Table table) {
        Menu menu = this.tableMenuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    protected List<FieldNoteItem> getAllItems() {
        return new ArrayList<FieldNoteItem>((Collection<FieldNoteItem>)this.baseList);
    }

    protected int getAllItemsCount() {
        return this.baseList.size();
    }

    protected List<FieldNoteItem> getSelectedItems() {
        return new ArrayList<FieldNoteItem>((Collection<FieldNoteItem>)this.tableViewer.getSelected());
    }

    protected int getSelectedItemsCount() {
        return this.tableViewer.getSelected().size();
    }

    protected void onPost(boolean testMode) {
        FieldNoteItemIterator iter;
        FieldNoteChecker checker;
        String msg;
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        List<FieldNoteItem> items = this.getAllItems();
        List<FieldNoteItem> selected = this.getSelectedItems();
        String msg1 = Messages.getString("FieldNotesView.confirmPostLog");
        String msg2 = Messages.getString("FieldNotesView.warningTestMode");
        String string = msg = testMode ? String.format("%s%n%n%s", msg1, msg2) : msg1;
        if (selected.size() > 0 && DialogUtils.showConfirm(msg) && (checker = new FieldNoteChecker(iter = new FieldNoteItemIterator(items, selected))).check()) {
            iter.reset();
            PostFieldNotesAction action = new PostFieldNotesAction(profile, iter, testMode);
            PluginExecutor.getInstance().executeAsync(action);
        }
    }

    protected void onTest() {
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        List<FieldNoteItem> selected = this.getSelectedItems();
        TestFieldNotesAction action = new TestFieldNotesAction(profile, selected);
        PluginExecutor.getInstance().executeAsync(action);
    }

    protected void onDownloadFieldNotes() {
        EventList<FieldNoteItem> items = this.baseList;
        if (items.size() > 0 && !DialogUtils.showConfirm(Messages.getString("FieldNotesView.confirmFieldNotesDiscard"))) {
            return;
        }
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        GetFieldNotesAction action = new GetFieldNotesAction(profile, (List<FieldNoteItem>)items);
        PluginExecutor.getInstance().executeAsync(action);
    }

    protected void onCreateFieldNotes() {
        EventList<FieldNoteItem> items = this.baseList;
        if (items.size() > 0 && !DialogUtils.showConfirm(Messages.getString("FieldNotesView.confirmFieldNotesDiscard"))) {
            return;
        }
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        CreateFieldNotesAction action = new CreateFieldNotesAction(profile, (List<FieldNoteItem>)items);
        PluginExecutor.getInstance().executeAsync(action);
    }

    protected void onListing() {
        List<FieldNoteItem> selected = this.getSelectedItems();
        if (selected.size() > 0) {
            int max = 10;
            int n = 0;
            for (FieldNoteItem item : selected) {
                String msg;
                String code;
                GeocacheSite site = item.getSite();
                boolean siteGC = GeocacheSite.GC.equals((Object)site);
                String url = null;
                if (url == null && StringUtils.notEmpty(code = item.getGeocacheCode())) {
                    if (siteGC) {
                        url = GcWebService.getListingUrlByCode(code);
                    }
                    if (url == null) {
                        url = OpencachingUtils.getListingUrlByCode(code);
                    }
                }
                if (url == null) {
                    String guid = item.getGuid();
                    if (siteGC && StringUtils.notEmpty(guid)) {
                        url = GcWebService.getListingUrlByGuid(guid);
                    }
                }
                if (!StringUtils.notEmpty(url)) continue;
                DesktopUtils.openUrl(url);
                ThreadUtils.sleep(100L);
                if (++n % 10 != 0) continue;
                DisplayUtils.forceActive(DisplayUtils.getShell());
                String string = msg = n > 10 ? String.format(Messages.getString("FieldNotesView.confirmNextListingsOpened"), 10) : String.format(Messages.getString("FieldNotesView.confirmFirstListingsOpened"), 10);
                if (!DialogUtils.showConfirm(msg)) break;
            }
        }
    }

    protected void onCheckStatus() {
        UserProfile profile = UserProfileService.getInstance().getCurrentProfile();
        List<FieldNoteItem> selected = this.getSelectedItems();
        GetGeocacheAction action = new GetGeocacheAction(profile, selected);
        PluginExecutor.getInstance().executeAsync(action);
    }

    protected void onFavorites(boolean flag) {
        List<FieldNoteItem> selected = this.getSelectedItems();
        FieldNoteOptionsHelper helper = new FieldNoteOptionsHelper();
        helper.onFavorites(selected, flag);
    }

    protected void onVisit(boolean flag) {
        List<FieldNoteItem> selected = this.getSelectedItems();
        FieldNoteOptionsHelper helper = new FieldNoteOptionsHelper();
        helper.onVisit(selected, flag);
    }

    protected void onLogDate() {
        List<FieldNoteItem> selected = this.getSelectedItems();
        if (selected.size() > 0) {
            EditLogDateDialog dialog = new EditLogDateDialog(DisplayUtils.getShell());
            dialog.setLogDate(selected.get(0).getLogDate());
            dialog.setDateOnly(false);
            if (dialog.open() == 0) {
                Date newLogDate = dialog.getLogDate();
                boolean dateOnly = dialog.getDateOnly();
                for (FieldNoteItem item : selected) {
                    if (dateOnly && item.getLogDate() != null) {
                        item.setLogDate(DateUtils.setDateOnly(item.getLogDate(), newLogDate));
                    } else {
                        item.setLogDate(newLogDate);
                    }
                    item.updateFieldNoteStatus();
                    item.notifyChange();
                }
            }
        }
    }

    protected void onLogType(GeocacheLogType logType) {
        String msg;
        AssertUtils.notNull((Object)logType, "Log type");
        List<FieldNoteItem> selected = this.getSelectedItems();
        if (selected.size() > 0 && DialogUtils.showConfirm(msg = selected.size() > 1 ? String.format(Messages.getString("FieldNotesView.confirmLogTypeChangeForAll"), new Object[]{logType}) : String.format(Messages.getString("FieldNotesView.confirmLogTypeChange"), new Object[]{logType}))) {
            for (FieldNoteItem item : selected) {
                item.setLogType(logType);
                item.updateFieldNoteStatus();
                item.notifyChange();
            }
        }
    }

    protected void onEdit() {
        List<FieldNoteItem> selected = this.getSelectedItems();
        if (selected.size() > 0) {
            String logText = null;
            for (FieldNoteItem item : selected) {
                logText = item.getLogText();
                if (StringUtils.notEmpty(logText)) break;
            }
            EditFieldNoteDialog dialog = new EditFieldNoteDialog(DisplayUtils.getShell());
            dialog.setLogText(StringUtils.trim2(logText));
            if (dialog.open() == 0) {
                logText = StringUtils.trim2(dialog.getLogText());
                for (FieldNoteItem item : selected) {
                    item.setLogText(logText);
                    item.notifyChange();
                }
            }
        }
    }

    protected void onEditRating() {
        List<FieldNoteItem> selected = this.getSelectedItems();
        if (selected.size() > 0) {
            Double rating = null;
            for (FieldNoteItem item : selected) {
                rating = item.getOptRating();
                if (rating != null) break;
            }
            EditFieldNoteRatingDialog dialog = new EditFieldNoteRatingDialog(DisplayUtils.getShell());
            dialog.setRating(rating);
            if (dialog.open() == 0) {
                rating = dialog.getRating();
                for (FieldNoteItem item : selected) {
                    item.setOptRating(rating);
                    item.notifyChange();
                }
            }
        }
    }

    protected void onEditPassword() {
        List<FieldNoteItem> selected = this.getSelectedItems();
        if (selected.size() > 0) {
            String password = null;
            for (FieldNoteItem item : selected) {
                password = item.getOptPassword();
                if (StringUtils.notEmpty(password)) break;
            }
            EditFieldNotePasswordDialog dialog = new EditFieldNotePasswordDialog(DisplayUtils.getShell());
            dialog.setPassword(password);
            if (dialog.open() == 0) {
                password = dialog.getPassword();
                for (FieldNoteItem item : selected) {
                    item.setOptPassword(password);
                    item.notifyChange();
                }
            }
        }
    }

    protected void onEditTag() {
        List<FieldNoteItem> selected = this.getSelectedItems();
        if (selected.size() > 0) {
            String tag = null;
            for (FieldNoteItem item : selected) {
                tag = item.getTag();
                if (StringUtils.notEmpty(tag)) break;
            }
            EditFieldNoteTagDialog dialog = new EditFieldNoteTagDialog(DisplayUtils.getShell());
            dialog.setTag(StringUtils.trim(tag));
            if (dialog.open() == 0) {
                tag = StringUtils.trim(dialog.getTag());
                for (FieldNoteItem item : selected) {
                    item.setTag(tag);
                    item.notifyChange();
                }
            }
        }
    }

    @Override
    public void onAction(ViewActionArgs args) {
        if (args.type != null) {
            switch (args.type) {
                case OPEN: {
                    this.onOpen(args);
                    break;
                }
                case TRY_CLOSE: {
                    this.onClose(args);
                    break;
                }
                case SAVE: {
                    this.onSave(args);
                    break;
                }
            }
        }
    }

    protected void onOpen(ViewActionArgs args) {
        OpenFieldNotesAction action = this.createOpenAction((String)args.data);
        PluginExecutor.getInstance().executeSync(action);
    }

    protected OpenFieldNotesAction createOpenAction(String filename) {
        return new OpenFieldNotesAction((List<FieldNoteItem>)this.baseList, filename, this.model);
    }

    protected void onClose(ViewActionArgs args) {
        if (this.model.isDirty()) {
            String title = StringUtils.nvl((String)args.data, Messages.getString("FieldNotesView.defaultDocumentName"));
            int resp = DialogUtils.showQuestionYesNoCancel(String.format(Messages.getString("FieldNotesView.confirmSaveChanges"), title));
            if (resp == 256) {
                args.doit = false;
                return;
            }
            if (resp == 64) {
                String filename = this.model.getFilename();
                if (filename == null) {
                    filename = FileDialogUtils.getFilenameToSave();
                }
                if (filename == null) {
                    args.doit = false;
                    return;
                }
                SaveFieldNotesAction action = this.createSaveAction(filename);
                PluginExecutor.getInstance().executeSync(action);
            }
        }
    }

    protected void onSave(ViewActionArgs args) {
        SaveFieldNotesAction action = this.createSaveAction((String)args.data);
        PluginExecutor.getInstance().executeAsync(action);
    }

    protected SaveFieldNotesAction createSaveAction(String filename) {
        List<FieldNoteItem> items = this.getAllItems();
        SaveFieldNotesArgs actionArgs = new SaveFieldNotesArgs(items, filename, this.model);
        SaveFieldNotesAction action = new SaveFieldNotesAction(actionArgs);
        return action;
    }

    @Override
    public void onCut() {
        Control ctrl = DisplayUtils.getDisplay().getFocusControl();
        if (ctrl == this.tableViewer.getTable()) {
            List<FieldNoteItem> selected = this.getSelectedItems();
            FieldNotesClipboardUtils.setContent(selected);
            this.baseList.removeAll(selected);
        }
    }

    @Override
    public void onCopy() {
        Control ctrl = DisplayUtils.getDisplay().getFocusControl();
        if (ctrl == this.tableViewer.getTable()) {
            List<FieldNoteItem> selected = this.getSelectedItems();
            FieldNotesClipboardUtils.setContent(selected);
        }
    }

    @Override
    public void onPaste() {
        List<FieldNoteItem> items;
        Control ctrl = DisplayUtils.getDisplay().getFocusControl();
        if (ctrl == this.tableViewer.getTable() && (items = FieldNotesClipboardUtils.getContent()) != null && items.size() > 0) {
            this.baseList.addAll(items);
            EventList sel = this.tableViewer.getTogglingSelected();
            sel.clear();
            sel.addAll(items);
        }
    }

    @Override
    public void onDelete() {
        List<FieldNoteItem> selected;
        Control ctrl = DisplayUtils.getDisplay().getFocusControl();
        if (ctrl == this.tableViewer.getTable() && (selected = this.getSelectedItems()).size() > 0 && DialogUtils.showConfirm(Messages.getString("FieldNotesView.confirmDelete"))) {
            this.baseList.removeAll(selected);
        }
    }

    @Override
    public void initMenuManager(IMenuManager menu) {
        List<Action> actions;
        if (StringUtils.equals(menu.getId(), "geocentral.menu.view") && (actions = this.viewConfigActions.getActions()).size() > 0) {
            for (Action action : actions) {
                menu.add((IAction)action);
            }
        }
    }
}

