/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swt.TableColumnConfigurer;
import ca.odell.glazedlists.swt.TableItemConfigurer;
import geocentral.api.groundspeak.mappers.GeocacheRating2ImageMapper;
import geocentral.api.groundspeak.mappers.GeocacheSize2ImageMapper;
import geocentral.api.groundspeak.ui.FieldNoteOptionsUtils;
import geocentral.common.Messages;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.geocaching.SiteImageProviderService;
import geocentral.common.geocaching.UserRatingUtils;
import geocentral.common.ui.DisplayUtils;
import geocentral.common.ui.ICustomDrawingConfigurer;
import geocentral.common.ui.ImageArray;
import geocentral.common.ui.dialogs.CharMetrics;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import geocentral.common.ui.preferences.PreferenceStoreManager;
import geocentral.ui.views.TableColumnConfig;
import geocentral.ui.views.TableViewConfig;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.OSUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FieldNoteItemTableFormat
implements TableFormat<FieldNoteItem>,
TableItemConfigurer<FieldNoteItem>,
TableColumnConfigurer,
ICustomDrawingConfigurer {
    private static final Log log = LogFactory.getLog(FieldNoteItemTableFormat.class);
    private static final SiteImageProviderService siteImageProvider = SiteImageProviderService.getInstance();
    private static final GeocacheSize2ImageMapper size2Image = new GeocacheSize2ImageMapper();
    private static final GeocacheRating2ImageMapper rating2Image = new GeocacheRating2ImageMapper();
    private static final boolean isLinux = OSUtils.isLinux();
    private final CharMetrics charMetrics;
    private TableColumnConfig[] columns;
    private DateFormat df;

    public FieldNoteItemTableFormat(TableViewConfig config) {
        AssertUtils.notNull(config, "Config");
        AssertUtils.notNull(config.getColumns(), "Config columns");
        this.charMetrics = WidgetSizeUtils.getCharMetrics(DisplayUtils.getShell());
        this.charMetrics.setMinSize(9, -1);
        this.initColumnConfig(config);
        this.initDateFormat(PreferenceStoreManager.getStore().getString("geocentral.preferences.general.date_format"));
    }

    private void initColumnConfig(TableViewConfig config) {
        LinkedList<TableColumnConfig> tmp = new LinkedList<TableColumnConfig>();
        for (TableColumnConfig c : config.getColumns()) {
            if (c == null) continue;
            if (c.getIndex() >= 0 && c.getIndex() < this.getAllColumnCount()) {
                tmp.add(c);
                continue;
            }
            log.debug((Object)String.format("Invalid configuration: %s. Column index out of range: %d", config.getId(), c.getIndex()));
        }
        if (tmp.size() == 0) {
            log.debug((Object)String.format("Configuration rejected: %s", config.getId()));
            int i = 0;
            while (i < this.getAllColumnCount()) {
                tmp.add(new TableColumnConfig(i));
                ++i;
            }
        }
        this.columns = tmp.toArray(new TableColumnConfig[tmp.size()]);
    }

    public void initDateFormat(String format) {
        try {
            this.df = new SimpleDateFormat(format);
        }
        catch (Exception e) {
            this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
    }

    protected int mapColumnIndex(int column) {
        AssertUtils.checkArgument(column >= 0 && column < this.columns.length, "Column index out of range");
        return this.columns[column].getIndex();
    }

    protected int getColumnWidth(int column) {
        AssertUtils.checkArgument(column >= 0 && column < this.columns.length, "Column index out of range");
        return this.columns[column].getWidth();
    }

    protected int getColumnMode(int column) {
        AssertUtils.checkArgument(column >= 0 && column < this.columns.length, "Column index out of range");
        return this.columns[column].getMode();
    }

    protected boolean isColumnModeImage(int column, boolean defaultValue) {
        int mode = this.getColumnMode(column);
        if (mode == 0) {
            return defaultValue;
        }
        return mode == 2;
    }

    private int getAllColumnCount() {
        return 19;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public String getColumnName(int column) {
        int col = this.mapColumnIndex(column);
        String name = this.columns[column].getName();
        switch (col) {
            case 0: {
                return "";
            }
            case 1: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.status"));
            }
            case 2: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.code"));
            }
            case 3: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.name"));
            }
            case 4: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.owner"));
            }
            case 5: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.difficulty"));
            }
            case 6: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.terrain"));
            }
            case 7: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.size"));
            }
            case 8: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.favorites"));
            }
            case 9: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.hint"));
            }
            case 10: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.logDate"));
            }
            case 11: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.logType"));
            }
            case 12: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.options"));
            }
            case 13: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.comment"));
            }
            case 14: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.tag"));
            }
            case 15: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.rating"));
            }
            case 16: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.ratingCount"));
            }
            case 17: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.optRating"));
            }
            case 18: {
                return StringUtils.nvl(name, Messages.getString("FieldNotesViewConfig.col.optPassword"));
            }
        }
        return null;
    }

    private String convertString(String str) {
        return isLinux ? StringUtils.firstLine(str) : str;
    }

    public Object getColumnValue(FieldNoteItem item, int column) {
        int col = this.mapColumnIndex(column);
        switch (col) {
            case 0: {
                return null;
            }
            case 1: {
                return item.getFieldNoteStatus();
            }
            case 2: {
                return this.convertString(item.getGeocacheCode());
            }
            case 3: {
                return this.convertString(item.getGeocacheName());
            }
            case 4: {
                return this.convertString(item.getGeocacheOwner());
            }
            case 5: {
                return item.getRatingDifficulty();
            }
            case 6: {
                return item.getRatingTerrain();
            }
            case 7: {
                return item.getSize();
            }
            case 8: {
                return item.getFavPoints();
            }
            case 9: {
                return this.convertString(item.getHint());
            }
            case 10: {
                return item.getLogDate();
            }
            case 11: {
                return item.getLogType();
            }
            case 12: {
                return item.getOptions();
            }
            case 13: {
                return this.convertString(item.getLogText());
            }
            case 14: {
                return this.convertString(item.getTag());
            }
            case 15: {
                return item.getRating();
            }
            case 16: {
                return item.getRatingVotes();
            }
            case 17: {
                return item.getOptRating();
            }
            case 18: {
                return this.convertString(item.getOptPassword());
            }
        }
        return null;
    }

    private String getColumnText(FieldNoteItem item, int column) {
        int col = this.mapColumnIndex(column);
        switch (col) {
            case 5: {
                if (this.isColumnModeImage(column, true)) {
                    return this.getCustomColumnImage(item, col) != null ? "             " : "";
                }
                return null;
            }
            case 6: {
                if (this.isColumnModeImage(column, true)) {
                    return this.getCustomColumnImage(item, col) != null ? "             " : "";
                }
                return null;
            }
            case 7: {
                if (this.isColumnModeImage(column, true)) {
                    return this.getCustomColumnImage(item, col) != null ? "          " : "";
                }
                return null;
            }
            case 10: {
                return item.getLogDate() != null ? this.df.format(item.getLogDate()) : null;
            }
            case 12: {
                switch (item.getOptions()) {
                    case 0: {
                        return "";
                    }
                    case 1: 
                    case 2: {
                        return "    ";
                    }
                }
                return "       ";
            }
            case 15: {
                return UserRatingUtils.getLabelByRating(item.getRating());
            }
            case 17: {
                return UserRatingUtils.getLabelByRating(item.getOptRating());
            }
        }
        return null;
    }

    private Image getColumnImage(FieldNoteItem item, int column) {
        int col = this.mapColumnIndex(column);
        switch (col) {
            case 2: {
                return siteImageProvider.getSiteIcon(item.getSite(), null);
            }
            case 3: {
                return siteImageProvider.getGeocacheTypeImage(item.getSite(), item.getType(), null);
            }
        }
        return null;
    }

    private Image getCustomColumnImage(FieldNoteItem item, int column) {
        int col = this.mapColumnIndex(column);
        switch (col) {
            case 5: {
                if (this.isColumnModeImage(column, true)) {
                    return rating2Image.getMappedValue(item.getRatingDifficulty(), null);
                }
                return null;
            }
            case 6: {
                if (this.isColumnModeImage(column, true)) {
                    return rating2Image.getMappedValue(item.getRatingTerrain(), null);
                }
                return null;
            }
            case 7: {
                if (this.isColumnModeImage(column, true)) {
                    return size2Image.getMappedValue(item.getSize(), null);
                }
                return null;
            }
            case 12: {
                return FieldNoteOptionsUtils.getOptionsImage(item.getOptions());
            }
        }
        return null;
    }

    @Override
    public boolean isCustomDrawn(int column) {
        int col = this.mapColumnIndex(column);
        switch (col) {
            case 5: 
            case 6: 
            case 7: {
                return this.isColumnModeImage(column, true);
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    public void configure(TableItem tableItem, FieldNoteItem item, Object columnValue, int row, int column) {
        String text = this.getColumnText(item, column);
        if (text != null) {
            tableItem.setText(column, text);
        } else {
            tableItem.setText(column, columnValue == null ? "" : columnValue.toString());
        }
        tableItem.setImage(column, this.getColumnImage(item, column));
        if (this.isCustomDrawn(column)) {
            ImageArray images;
            Image image = this.getCustomColumnImage(item, column);
            Object data = tableItem.getData();
            if (data instanceof ImageArray) {
                images = (ImageArray)data;
            } else {
                images = new ImageArray(this.getColumnCount());
                tableItem.setData((Object)images);
            }
            images.setImage(column, image);
        }
    }

    public void configure(TableColumn tc, final int column) {
        int col = this.mapColumnIndex(column);
        int width = this.columns[column].getWidth();
        tc.setMoveable(true);
        tc.setResizable(true);
        switch (col) {
            case 0: {
                tc.setWidth(0);
                tc.setMoveable(false);
                tc.setResizable(false);
                break;
            }
            case 1: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(10));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.status"));
                break;
            }
            case 2: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(11) + 16);
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.code"));
                break;
            }
            case 3: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(28) + 16);
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.name"));
                break;
            }
            case 4: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(12));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.owner"));
                break;
            }
            case 5: {
                tc.setWidth(width > 0 ? width : 80);
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.difficulty"));
                break;
            }
            case 6: {
                tc.setWidth(width > 0 ? width : 80);
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.terrain"));
                break;
            }
            case 7: {
                tc.setWidth(width > 0 ? width : 80);
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.size"));
                break;
            }
            case 8: {
                tc.setAlignment(131072);
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(5));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.favorites"));
                break;
            }
            case 9: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(10));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.hint"));
                break;
            }
            case 10: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(17));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.logDate"));
                break;
            }
            case 11: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(12));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.logType"));
                break;
            }
            case 12: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(6));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.options"));
                break;
            }
            case 13: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(30));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.comment"));
                break;
            }
            case 14: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(12));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.tag"));
                break;
            }
            case 15: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(11));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.rating"));
                break;
            }
            case 16: {
                tc.setAlignment(131072);
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(6));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.ratingCount"));
                break;
            }
            case 17: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(11));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.optRating"));
                break;
            }
            case 18: {
                tc.setWidth(width > 0 ? width : this.charMetrics.getWidth(11));
                tc.setToolTipText(Messages.getString("FieldNotesViewConfig.desc.optPassword"));
            }
        }
        tc.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (e.widget instanceof TableColumn) {
                    TableColumn tc = (TableColumn)e.widget;
                    int width = tc.getWidth();
                    FieldNoteItemTableFormat.this.columns[column].setUserWidth(width);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }
}

