/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.ui;

import geocentral.common.Messages;
import geocentral.common.geocaching.UserRatingUtils;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EditFieldNoteRatingDialog
extends TitleAreaDialog {
    private Combo combo;
    private Double rating;

    public EditFieldNoteRatingDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67680);
    }

    public Double getRating() {
        return this.rating;
    }

    public void setRating(Double rating) {
        this.rating = rating;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("EditFieldNoteRatingDialog.title"));
        this.setMessage(Messages.getString("EditFieldNoteRatingDialog.message"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblTag = new Label(container, 0);
        lblTag.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTag.setText(Messages.getString("EditFieldNoteRatingDialog.rating"));
        this.combo = new Combo(container, 8);
        this.combo.setItems(UserRatingUtils.getAllLabels());
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.combo.select(UserRatingUtils.mapRatingToIndex(this.rating));
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 60, 14);
        if (result != null) {
            return result;
        }
        return super.getInitialSize();
    }

    protected void okPressed() {
        if (this.checkInput()) {
            this.saveInput();
            super.okPressed();
        }
    }

    private boolean checkInput() {
        return true;
    }

    private void saveInput() {
        this.setRating(UserRatingUtils.mapIndexToRating(this.combo.getSelectionIndex()));
    }
}

