/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak.json;

import geocentral.api.groundspeak.json.GeocacheParser;
import geocentral.api.groundspeak.mappers.Id2LogTypeMapper;
import geocentral.common.data.DataReaderContext;
import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteType;
import geocentral.common.data.GeocacheItem;
import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.geocaching.GeocacheSite;
import java.util.Date;
import org.bacza.utils.DateUtils;
import org.bacza.utils.StringUtils;

public class LogDraftsDataParser
extends UserParser {
    private static final Id2LogTypeMapper id2LogTypeMapper = new Id2LogTypeMapper();
    private FieldNoteItem item;
    private GeocacheParser geocacheParser;

    public LogDraftsDataParser(DataReaderContext readerContext) {
        super(readerContext);
    }

    @Override
    public void startProcessing() {
        this.item = new FieldNoteItem();
        this.item.setFieldNoteType(FieldNoteType.ONLINE);
        this.item.setSite(GeocacheSite.GC);
        this.geocacheParser = null;
    }

    @Override
    public void stopProcessing() {
        this.readerContext.getDataStore().putItem(this.item);
        this.item = null;
    }

    @Override
    public void startElement(String name) {
        if ("geocache".equals(name)) {
            this.geocacheParser = new GeocacheParser(this.readerContext);
            this.installParser(this.geocacheParser);
        }
    }

    @Override
    public void endElement(String name) {
        GeocacheItem gc;
        if ("geocache".equals(name) && (gc = this.geocacheParser.getGeocacheItem()) != null) {
            this.item.setGeocacheCode(gc.getCode());
            this.item.setGeocacheName(gc.getName());
            this.item.setType(gc.getType());
        }
    }

    @Override
    public void value(String name, Object value, IAttributes attrs) {
        if ("logTypeId".equals(name)) {
            this.item.setLogType(id2LogTypeMapper.getMappedValue(LogDraftsDataParser.getValueAsString(value), null));
        } else if ("referenceCode".equals(name)) {
            this.item.setRefCode(LogDraftsDataParser.getValueAsString(value));
        } else if ("guid".equals(name)) {
            this.item.setGuid(LogDraftsDataParser.getValueAsString(value));
        } else if ("note".equals(name)) {
            this.item.setLogText(LogDraftsDataParser.getValueAsString(value));
        } else if ("notePreview".equals(name)) {
            if (StringUtils.isEmpty(this.item.getLogText())) {
                this.item.setLogText(LogDraftsDataParser.getValueAsString(value));
            }
        } else if ("dateLoggedGeocacheTime".equals(name)) {
            Date date = DateUtils.parseDate(LogDraftsDataParser.getValueAsString(value), "yyyy-MM-dd'T'HH:mm:ss");
            this.item.setLogDate(date);
        }
    }
}

