/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.jsoup.nodes.Element;

public class RecaptchaParser {
    private String imageLink;

    public RecaptchaParser(Element root) throws ParseException {
        this.parse(root);
    }

    private void parse(Element root) throws ParseException {
        AssertUtils.notNull(root, "Root");
        AssertUtils.notNull(root.baseUri(), "Base URI");
        Element img = root.getElementById("recaptcha_challenge_image");
        if (img != null) {
            String src = img.attr("src");
            ParseAssert.notNull(src, 1000);
            this.imageLink = src;
        }
    }

    public String getImageLink() {
        return this.imageLink;
    }

    public boolean hasImageLink() {
        return this.imageLink != null;
    }
}

