/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import geocentral.api.groundspeak.PocketQueryMeta;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.http.URLUtils;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PocketQueryParser {
    private static final DateFormat DF_SERVER_TIME = PocketQueryParser.createDateFormat("E, dd MMM yyyy HH:mm:ss");
    private static final DateFormat DF_GENERATED_TIME = PocketQueryParser.createDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat DF_GENERATED_TIME_SIMPLE = PocketQueryParser.createDateFormat("yyyy-MM-dd");
    private List<PocketQueryMeta> pqList = new LinkedList<PocketQueryMeta>();
    private Map<String, PocketQueryMeta> pqByName = new HashMap<String, PocketQueryMeta>();
    private Date serverTime = null;

    private static DateFormat createDateFormat(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("PST"));
        return df;
    }

    public PocketQueryParser(Element root) throws ParseException {
        this.parse(root);
    }

    private void parse(Element root) throws ParseException {
        AssertUtils.notNull(root, "Root");
        this.parseActivePQs(root);
        this.parseDownloadablePQs(root);
    }

    private void parseActivePQs(Element root) throws ParseException {
        Element div = root.select("div#ActivePQs").first();
        ParseAssert.notNull(div, 1000);
        Element p = div.select("p").first();
        ParseAssert.notNull(p, 1010);
        String text = p.text();
        ParseAssert.notEmpty(text, 1011);
        int i = text.toLowerCase().indexOf("server time:");
        ParseAssert.check(i >= 0, 1012);
        text = text.substring(i + 12).trim();
        ParseAssert.notEmpty(text, 1013);
        this.serverTime = DateUtils.parseDate(text, DF_SERVER_TIME);
        ParseAssert.notNull(this.serverTime, 1014);
        Element tabPQ = div.select("table#pqRepeater").first();
        Element tabMyFinds = div.select("table#ctl00_ContentBody_PQListControl1_tblMyFinds").first();
        ParseAssert.check(tabPQ != null || tabMyFinds != null, 1020);
        if (tabPQ == null) {
            return;
        }
        Elements rows = tabPQ.select("tbody > tr");
        ParseAssert.check(rows.size() > 0, 1021);
        int countPQs = 0;
        int countFooters = 0;
        for (Element row : rows) {
            boolean isFooter = "TableFooter".equals(row.attr("class"));
            if (isFooter) {
                ++countFooters;
                continue;
            }
            ++countPQs;
            Elements cols = row.getElementsByTag("td");
            ParseAssert.check(cols.size() == 13, 1022);
            Element a = cols.get(3).getElementsByTag("a").first();
            ParseAssert.notNull(a, 1023);
            String name = StringUtils.nvl(a.text(), a.attr("title"));
            ParseAssert.notEmpty(name, 1024);
            String link = URLUtils.decode(a.attr("href"));
            String guid = URLUtils.getParamValue(link, "guid");
            ParseAssert.notEmpty(guid, 1025);
            PocketQueryMeta pq = new PocketQueryMeta(name, guid);
            i = 0;
            while (i < 7) {
                Element dayA = cols.get(5 + i).getElementsByTag("a").first();
                ParseAssert.notNull(dayA, 1026);
                String dayLink = URLUtils.decode(dayA.attr("href"));
                Integer day = StringUtils.parseInteger(URLUtils.getParamValue(dayLink, "d"));
                Integer opt = StringUtils.parseInteger(URLUtils.getParamValue(dayLink, "opt"));
                ParseAssert.check(day >= 0 && day <= 6, 1027);
                ParseAssert.check(opt >= 0 && opt <= 1, 1027);
                switch (day) {
                    case 0: {
                        pq.setCheckedSu(opt == 0);
                        break;
                    }
                    case 1: {
                        pq.setCheckedMo(opt == 0);
                        break;
                    }
                    case 2: {
                        pq.setCheckedTu(opt == 0);
                        break;
                    }
                    case 3: {
                        pq.setCheckedWe(opt == 0);
                        break;
                    }
                    case 4: {
                        pq.setCheckedTh(opt == 0);
                        break;
                    }
                    case 5: {
                        pq.setCheckedFr(opt == 0);
                        break;
                    }
                    case 6: {
                        pq.setCheckedSa(opt == 0);
                    }
                }
                ++i;
            }
            String generatedStr = cols.get(12).text();
            ParseAssert.notEmpty(generatedStr, 1028);
            if (!generatedStr.contains("Never")) {
                Date generated = DateUtils.parseDate(generatedStr.trim(), DF_GENERATED_TIME);
                ParseAssert.notNull(generated, 1028);
                pq.setLastGenerated(generated);
            }
            pq.setActive(true);
            this.pqList.add(pq);
            this.pqByName.put(pq.getName(), pq);
        }
        ParseAssert.check(countPQs == this.pqList.size(), 1030);
        ParseAssert.check(countFooters > 0, 1031);
    }

    private void parseDownloadablePQs(Element root) throws ParseException {
        Element div = root.select("div#DownloadablePQs").first();
        ParseAssert.notNull(div, 1200);
        Element tabPQ = div.select("table#uxOfflinePQTable").first();
        ParseAssert.notNull(tabPQ, 1210);
        Elements rows = tabPQ.select("tbody > tr");
        ParseAssert.check(rows.size() > 0, 1221);
        int countPQs = 0;
        int countFooters = 0;
        for (Element row : rows) {
            boolean isFooter = "TableFooter".equals(row.attr("class"));
            if (isFooter) {
                ++countFooters;
                continue;
            }
            ++countPQs;
            Elements cols = row.getElementsByTag("td");
            ParseAssert.check(cols.size() == 6, 1222);
            Element a = cols.get(2).getElementsByTag("a").first();
            ParseAssert.notNull(a, 1223);
            String name = a.text();
            ParseAssert.notEmpty(name, 1224);
            String link = URLUtils.decode(a.attr("href"));
            String guid = URLUtils.getParamValue(link, "g");
            ParseAssert.notEmpty(guid, 1225);
            boolean created = false;
            PocketQueryMeta pq = this.getPQByName(name);
            if (pq == null) {
                pq = new PocketQueryMeta(name, guid);
                created = true;
            }
            Integer waypoints = StringUtils.parseInteger(cols.get(4).text());
            ParseAssert.notNull(waypoints, 1227);
            pq.setWaypoints(waypoints);
            String generatedStr = cols.get(5).text();
            ParseAssert.notEmpty(generatedStr, 1228);
            if (pq.getLastGenerated() == null) {
                Date generated = DateUtils.parseDate(generatedStr, DF_GENERATED_TIME_SIMPLE);
                ParseAssert.notNull(generated, 1228);
                pq.setLastGenerated(generated);
            }
            String daysStr = generatedStr.replaceAll("[^\\(]+\\(([0-9]+)[^\\)]+\\)", "$1");
            Integer days = StringUtils.parseInteger(daysStr);
            ParseAssert.notNull(days, 1228);
            pq.setDaysRemaining(days);
            pq.setDownloadable(true);
            if (!created) continue;
            this.pqList.add(pq);
            this.pqByName.put(pq.getName(), pq);
        }
        ParseAssert.check(countFooters == 1, 1230);
    }

    public List<PocketQueryMeta> getPQList() {
        return this.pqList;
    }

    public PocketQueryMeta getPQByName(String name) {
        if (name != null) {
            return this.pqByName.get(name);
        }
        return null;
    }

    public Date getServerTime() {
        return this.serverTime;
    }
}

