/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.jsoup.nodes.Element;

public class LogPageParser {
    private String logDateFormat;

    public LogPageParser(Element root) throws ParseException {
        this.parse(root);
    }

    private void parse(Element root) throws ParseException {
        AssertUtils.notNull(root, "Root");
        Element main = root.getElementById("ctl00_ContentBody_LogBookPanel1_EditLogPanel");
        ParseAssert.notNull(main, 1000);
        Element formatHint = main.getElementById("ctl00_ContentBody_LogBookPanel1_uxDateFormatHint");
        ParseAssert.notNull(formatHint, 1100);
        String hint = formatHint.text();
        ParseAssert.notEmpty(hint, 1110);
        hint = hint.replaceFirst("\\(([^\\)]+)\\)", "$1");
        ParseAssert.notEmpty(hint, 1120);
        this.logDateFormat = hint;
    }

    public String getLogDateFormat() {
        return this.logDateFormat;
    }
}

