/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import geocentral.api.groundspeak.PreferencesMeta;
import geocentral.api.groundspeak.mappers.GeocacheSizeMapper;
import geocentral.api.groundspeak.mappers.WaypointTypeMapper;
import geocentral.common.data.GeocacheItem;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSize;
import geocentral.common.geocaching.GeocacheType;
import geocentral.common.geocaching.Rot13Utils;
import java.util.Date;
import java.util.Set;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.http.URLUtils;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GeocacheParser {
    private static final WaypointTypeMapper wptTypeMapper = new WaypointTypeMapper();
    private static final GeocacheSizeMapper sizeMapper = new GeocacheSizeMapper();
    private GeocacheItem geocache;

    public GeocacheParser(Element root, PreferencesMeta prefs) throws ParseException {
        this.parse(root, prefs);
    }

    private void parse(Element root, PreferencesMeta prefs) throws ParseException {
        Element divHint;
        String text;
        Element span;
        Element favCont;
        Element sizeImg;
        Element divSize;
        Elements imgs;
        Element divRatings;
        Element typeImg;
        Element detailsDiv;
        Element mainDiv;
        GeocacheItem gc;
        block26: {
            Set foundDivClass;
            GeocacheLogType logType;
            Element foundDiv;
            String str;
            block27: {
                Element pmo;
                AssertUtils.notNull(root, "Root");
                AssertUtils.notNull(root.baseUri(), "Base URI");
                AssertUtils.notNull(prefs, "Preferences");
                gc = new GeocacheItem();
                mainDiv = root.getElementById("divContentMain");
                if (mainDiv == null && (pmo = root.select("div#ctl00_divContentMain section.pmo-banner").first()) != null) {
                    gc.setPremiumOnly(true);
                    this.geocache = gc;
                    return;
                }
                ParseAssert.notNull(mainDiv, 1000);
                Element codeSpan = root.getElementById("ctl00_ContentBody_CoordInfoLinkControl1_uxCoordInfoCode");
                ParseAssert.notNull(codeSpan, 1005);
                String code = codeSpan.text();
                ParseAssert.notNull(code, 1006);
                gc.setCode(code);
                detailsDiv = mainDiv.getElementById("cacheDetails");
                ParseAssert.notNull(detailsDiv, 1100);
                Element spanName = detailsDiv.getElementById("ctl00_ContentBody_CacheName");
                ParseAssert.notNull(spanName, 1110);
                gc.setName(spanName.text());
                Element mcd1 = detailsDiv.getElementById("ctl00_ContentBody_mcd1");
                ParseAssert.notNull(mcd1, 1120);
                Element ownerLink = mcd1.getElementsByTag("a").first();
                ParseAssert.notNull(ownerLink, 1130);
                str = ownerLink.text();
                ParseAssert.notEmpty(str, 1132);
                gc.setOwner(str);
                Element logButton = mainDiv.getElementById("ctl00_ContentBody_GeoNav_logButton");
                ParseAssert.notNull(logButton, 1200);
                str = logButton.attr("href");
                ParseAssert.notNull(str, 1205);
                gc.setNewLogLink(URLUtils.abs(root.baseUri(), str));
                Element navDiv = logButton.parent();
                foundDiv = navDiv.getElementById("ctl00_ContentBody_GeoNav_foundStatus");
                if (foundDiv == null) break block26;
                logType = null;
                Element img = foundDiv.getElementById("ctl00_ContentBody_GeoNav_logTypeImage");
                if (img == null) break block27;
                ParseAssert.notNull(img, 1210);
                String src = img.attr("src");
                ParseAssert.notNull(src, 1211);
                String logTypeStr = src.replaceFirst("/images/logtypes/[0-9]+/([0-9]+).png", "$1");
                ParseAssert.notNull(logTypeStr, 1212);
                switch (logTypeStr) {
                    case "2": {
                        logType = GeocacheLogType.FOUND_IT;
                        break;
                    }
                    case "3": {
                        logType = GeocacheLogType.DNF;
                        break;
                    }
                    case "10": {
                        logType = GeocacheLogType.ATTENDED;
                        break;
                    }
                    case "11": {
                        logType = GeocacheLogType.WEBCAM_PHOTO_TAKEN;
                    }
                }
            }
            if (logType == null && (foundDivClass = foundDiv.classNames()) != null && foundDivClass.contains("WillAttend")) {
                logType = GeocacheLogType.WILL_ATTEND;
            }
            gc.setExistingLogType(logType);
            Element logLink = foundDiv.select("#ctl00_ContentBody_GeoNav_logDate a").first();
            ParseAssert.notNull(logLink, 1220);
            str = logLink.text();
            ParseAssert.notEmpty(str, 1220);
            String format = prefs.getDateFormat();
            Date date = null;
            int i = 0;
            int len = str.length();
            while (date == null && i < len) {
                date = DateUtils.parseDate(str.substring(i++), format);
            }
            gc.setExistingLogDate(date);
            str = logLink.attr("href");
            ParseAssert.notEmpty(str, 1220);
            gc.setExistingLogLink(URLUtils.abs(root.baseUri(), str));
        }
        if ((typeImg = detailsDiv.select("div#uxCacheImage svg use[xlink:href*=/sprites/cache-types.svg]").first()) != null) {
            String src = typeImg.attr("xlink:href");
            ParseAssert.notNull(src, 1300);
            String geocacheTypeStr = src.replaceAll(".*/cache-types.svg#icon-([^-]+).*", "$1");
            ParseAssert.notNull(geocacheTypeStr, 1310);
            GeocacheType geocacheType = wptTypeMapper.getMappedValue(StringUtils.trim(geocacheTypeStr), null);
            gc.setType(geocacheType);
        }
        if ((divRatings = mainDiv.getElementById("ctl00_ContentBody_diffTerr")) != null && (imgs = divRatings.select("img[src*=/images/stars/]")).size() == 2) {
            Double rating;
            String src = imgs.get(0).attr("src");
            if (StringUtils.notEmpty(src = src.replaceAll(".+/stars([^.]+).gif", "$1"))) {
                rating = StringUtils.parseDouble(src.replace('_', '.'));
                gc.setRatingDifficulty(rating);
            }
            src = imgs.get(1).attr("src");
            if (StringUtils.notEmpty(src = src.replaceAll(".+/stars([^.]+).gif", "$1"))) {
                rating = StringUtils.parseDouble(src.replace('_', '.'));
                gc.setRatingTerrain(rating);
            }
        }
        if ((divSize = mainDiv.getElementById("ctl00_ContentBody_size")) != null && (sizeImg = divSize.select("img[src*=/images/icons/container/]").first()) != null) {
            String src = sizeImg.attr("src");
            ParseAssert.notNull(src, 1400);
            String geocacheSizeStr = src.replaceAll(".+/([^.]+).gif", "$1");
            ParseAssert.notNull(geocacheSizeStr, 1410);
            GeocacheSize size = sizeMapper.getMappedValue(geocacheSizeStr, null);
            gc.setSize(size);
        }
        if ((favCont = mainDiv.getElementById("uxFavContainerLink")) != null && (span = favCont.select("span.favorite-value").first()) != null && (text = span.text()) != null) {
            text = text.replace(",", "");
            text = text.replace(".", "");
            Integer favPoints = StringUtils.parseInteger(text);
            gc.setFavPoints(favPoints);
        }
        if ((divHint = mainDiv.getElementById("div_hint")) != null) {
            String hint = divHint.text();
            gc.setHint(Rot13Utils.rot13(hint));
        }
        this.geocache = gc;
    }

    public GeocacheItem getGeocache() {
        return this.geocache;
    }
}

