/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import geocentral.api.groundspeak.PreferencesMeta;
import java.util.Date;
import org.bacza.utils.DateUtils;

public final class GcUserPrefUtils {
    private static final GcUserPrefUtils instance = new GcUserPrefUtils();
    private PreferencesMeta preferences;
    private Date lastUpdated;

    public static GcUserPrefUtils getInstance() {
        return instance;
    }

    private GcUserPrefUtils() {
    }

    public PreferencesMeta getPreferences() {
        return this.preferences;
    }

    public void setPreferences(PreferencesMeta preferences) {
        this.preferences = preferences;
        this.lastUpdated = new Date();
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public double getMinutesSinceLastUpdate() {
        return DateUtils.getMinutesBetween(this.lastUpdated, new Date());
    }

    public boolean hasCurrentPreferencesMinutes(int minutes) {
        double m = this.getMinutesSinceLastUpdate();
        return this.preferences != null && m <= (double)minutes;
    }
}

