/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import geocentral.common.ws.LoginRequiredException;
import geocentral.common.ws.WsTaskInfo;
import org.bacza.data.html.DocumentData;
import org.bacza.data.html.FormData;
import org.bacza.data.html.LoginAssert;
import org.bacza.utils.AssertUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public final class GcLoginAssert {
    public static void checkLoggedIn(Document doc, DocumentData data, WsTaskInfo info) throws LoginRequiredException {
        if (GcLoginAssert.hasPasswordForm(doc, data)) {
            throw new LoginRequiredException(info);
        }
        if (GcLoginAssert.hasLoginStatusNotSignedIn(doc, data)) {
            throw new LoginRequiredException(info);
        }
    }

    public static boolean hasPasswordForm(Document doc, DocumentData data) {
        AssertUtils.notNull(doc, "Document");
        AssertUtils.notNull(data, "DocumentData");
        FormData form = LoginAssert.findPasswordForm(data);
        return form != null;
    }

    public static boolean hasLogoutForm(Document doc, DocumentData data) {
        AssertUtils.notNull(doc, "Document");
        AssertUtils.notNull(data, "DocumentData");
        for (FormData form : data.getForms()) {
            if (form == null) continue;
            String action = form.getAction();
            String id = form.getId();
            if (action != null && action.contains("/account/logout")) {
                return true;
            }
            if (id == null || !id.contains("form-logout")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLoginStatusSignedIn(Document doc, DocumentData data) {
        AssertUtils.notNull(doc, "Document");
        AssertUtils.notNull(data, "DocumentData");
        Element div = doc.select("#ctl00_siteHeader #ctl00_uxLoginStatus_divSignedIn").first();
        return div != null;
    }

    public static boolean hasLoginStatusNotSignedIn(Document doc, DocumentData data) {
        AssertUtils.notNull(doc, "Document");
        AssertUtils.notNull(data, "DocumentData");
        Element div1 = doc.select("#ctl00_siteHeader #ctl00_uxLoginStatus_divNotSignedIn").first();
        Element div2 = doc.select("#gcNavigation #ctl00_uxLoginStatus_divNotSignedIn").first();
        return div1 != null || div2 != null;
    }
}

