/*
 * Decompiled with CFR 0.152.
 */
package geocentral.api.groundspeak;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bacza.data.parsers.ParseAssert;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.nodes.Element;

public class EmbeddedJsonParser {
    public final JSONObject json;
    public final Set<Integer> logTypes;
    public final List<String> trackables;

    public EmbeddedJsonParser(Element root, String elementId) throws ParseException {
        AssertUtils.notNull(root, "Root");
        AssertUtils.notNull(elementId, "Element ID");
        String selector = String.format("script#%s[type=application/json]", elementId);
        Element script = root.select(selector).first();
        JSONObject json = null;
        Set<Integer> logTypes = null;
        List<String> trackables = null;
        try {
            try {
                if (script != null) {
                    json = new JSONObject(script.data());
                    logTypes = this.getLogTypes((JSONArray)json.query("/props/pageProps/logTypes"));
                    trackables = this.getTrackables((JSONArray)json.query("/props/pageProps/trackables"));
                }
            }
            catch (JSONException e) {
                ParseAssert.check(false, 1100);
                this.json = json;
                this.logTypes = logTypes;
                this.trackables = trackables;
            }
        }
        finally {
            this.json = json;
            this.logTypes = logTypes;
            this.trackables = trackables;
        }
    }

    public boolean isLogTypeIdValid(Integer logTypeId) {
        if (this.logTypes != null && logTypeId != null) {
            return this.logTypes.contains(logTypeId);
        }
        return false;
    }

    private Set<Integer> getLogTypes(JSONArray array) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (array != null) {
            array.forEach(item -> {
                int value;
                if (item instanceof JSONObject && (value = ((JSONObject)item).optInt("value", -1)) >= 0) {
                    result.add(value);
                }
            });
        }
        return result;
    }

    private List<String> getTrackables(JSONArray array) {
        LinkedList<String> result = new LinkedList<String>();
        if (array != null) {
            array.forEach(item -> {
                String value;
                if (item instanceof JSONObject && (value = ((JSONObject)item).optString("referenceCode", null)) != null) {
                    result.add(value);
                }
            });
        }
        return result;
    }
}

