/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

public class Stopwatch {
    private long start;
    private long time;
    private int hours;
    private int minutes;
    private int seconds;
    private int millis;

    public Stopwatch() {
        this.reset();
    }

    public synchronized void reset() {
        this.start = -1L;
        this.time = 0L;
        this.calc(this.time);
    }

    public synchronized void start() {
        if (this.start < 0L) {
            this.start = System.currentTimeMillis();
        }
    }

    public synchronized void stop() {
        if (this.start > 0L) {
            long stop = System.currentTimeMillis();
            if (stop > this.start) {
                this.time += stop - this.start;
                this.calc(this.time);
            }
            this.start = -1L;
        }
    }

    private void calc(long t) {
        this.hours = (int)(t / 3600000L);
        this.minutes = (int)((t -= (long)(this.hours * 3600000)) / 60000L);
        this.seconds = (int)((t -= (long)(this.minutes * 60000)) / 1000L);
        this.millis = (int)(t -= (long)(this.seconds * 1000));
    }

    public synchronized long getTime() {
        return this.time;
    }

    public synchronized int getHours() {
        return this.hours;
    }

    public synchronized int getMinutes() {
        return this.minutes;
    }

    public synchronized int getSeconds() {
        return this.seconds;
    }

    public synchronized int getMillis() {
        return this.millis;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d.%03d", this.hours, this.minutes, this.seconds, this.millis);
    }
}

