/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.IndependentAttributeProviderFactory;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.util.Arrays;

public class SimpleHtmlRenderer {
    private final Parser parser;
    private final HtmlRenderer renderer;

    public SimpleHtmlRenderer() {
        MutableDataSet options = new MutableDataSet();
        options.set(HtmlRenderer.SOFT_BREAK, (Object)"\n<br />\n");
        options.set(Parser.EXTENSIONS, Arrays.asList(LinkTargetExtension.create()));
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    public String render(String markdown) {
        Document document = this.parser.parse(markdown);
        return this.renderer.render((Node)document);
    }

    static class LinkTargetAttributeProvider
    implements AttributeProvider {
        LinkTargetAttributeProvider() {
        }

        public void setAttributes(Node node, AttributablePart part, Attributes attributes) {
            if (node instanceof Link && part == AttributablePart.LINK) {
                attributes.replaceValue((CharSequence)"target", (CharSequence)"_blank");
            }
        }

        static AttributeProviderFactory createFactory() {
            return new IndependentAttributeProviderFactory(){

                public AttributeProvider create(LinkResolverContext context) {
                    return new LinkTargetAttributeProvider();
                }
            };
        }
    }

    static class LinkTargetExtension
    implements HtmlRenderer.HtmlRendererExtension {
        LinkTargetExtension() {
        }

        public void rendererOptions(MutableDataHolder options) {
        }

        public void extend(HtmlRenderer.Builder rendererBuilder, String rendererType) {
            rendererBuilder.attributeProviderFactory(LinkTargetAttributeProvider.createFactory());
        }

        static Extension create() {
            return new LinkTargetExtension();
        }
    }
}

