/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public final class ScreenCaptureUtils {
    public static Image captureImage(Shell shell, Rectangle rec) {
        GC gc = new GC((Drawable)shell.getDisplay());
        Image image = new Image((Device)shell.getDisplay(), rec.width, rec.height);
        gc.copyArea(image, rec.x, rec.y);
        gc.dispose();
        return image;
    }

    public static void captureImageToFile(Shell shell, String filename) {
        Rectangle rec = new Rectangle(shell.getLocation().x, shell.getLocation().y, shell.getSize().x, shell.getSize().y);
        ScreenCaptureUtils.captureImageToFile(shell, rec, filename);
    }

    public static void captureImageToFile(Shell shell, Rectangle rec, String filename) {
        Image image = ScreenCaptureUtils.captureImage(shell, rec);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(filename, 5);
    }
}

