/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import org.bacza.utils.StringUtils;

public final class OSUtils {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_SHORT_NAME_WINDOWS = "Windows";
    public static final String OS_SHORT_NAME_LINUX = "Linux";
    public static final String OS_SHORT_NAME_MAC = "Mac";
    public static final String JAVA_SPEC_VERSION = System.getProperty("java.specification.version");
    public static final float JAVA_SPEC_VERSION_NUM = OSUtils.getSpecVersionNum(JAVA_SPEC_VERSION);

    public static boolean isWindows() {
        return StringUtils.contains(OS_NAME, OS_SHORT_NAME_WINDOWS);
    }

    public static boolean isLinux() {
        return StringUtils.contains(OS_NAME, OS_SHORT_NAME_LINUX);
    }

    public static boolean isMacOS() {
        return StringUtils.contains(OS_NAME, OS_SHORT_NAME_MAC);
    }

    public static String getShortName() {
        if (OSUtils.isWindows()) {
            return OS_SHORT_NAME_WINDOWS;
        }
        if (OSUtils.isLinux()) {
            return OS_SHORT_NAME_LINUX;
        }
        if (OSUtils.isMacOS()) {
            return OS_SHORT_NAME_MAC;
        }
        return OS_NAME;
    }

    private static float getSpecVersionNum(String version) {
        try {
            return Float.parseFloat(version);
        }
        catch (Exception e) {
            return 1.0f;
        }
    }
}

