/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bacza.utils.FileUtils;
import org.bacza.utils.OSUtils;
import org.bacza.utils.StringUtils;

public final class OSRelease {
    private static final String FILENAME = "/etc/os-release";
    private static final OSRelease instance = new OSRelease();
    private final Map<String, String> props = new HashMap<String, String>();
    private final boolean initialized = this.init();

    public static final OSRelease getInstance() {
        return instance;
    }

    private OSRelease() {
    }

    private boolean init() {
        try {
            List<String> lines = FileUtils.readFileAsStrings(FILENAME);
            Pattern pattern = Pattern.compile("^([a-zA-Z0-9_]+)=(.*)$");
            for (String line : lines) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                String name = StringUtils.trim(matcher.group(1));
                String value = StringUtils.trim(matcher.group(2));
                if (!StringUtils.notEmpty(name)) continue;
                this.props.put(StringUtils.toUpperCase(name), StringUtils.stripQuotes(value));
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getId() {
        return StringUtils.capitalize(this.getProperty("ID"));
    }

    public String getName() {
        return this.getProperty("NAME");
    }

    public String getPrettyName() {
        return this.getProperty("PRETTY_NAME");
    }

    public String getVersion() {
        return this.getProperty("VERSION");
    }

    public String getVersionId() {
        return this.getProperty("VERSION_ID");
    }

    public String getProperty(String name) {
        return this.props.get(name);
    }

    public String getShortName() {
        return StringUtils.coalesce(this.getId(), this.getName());
    }

    public String getShortVersion() {
        return StringUtils.coalesce(this.getVersionId(), this.getVersion());
    }

    public String getShortRelease() {
        String name = this.getShortName();
        if (StringUtils.isEmpty(name)) {
            return OSUtils.OS_NAME;
        }
        String version = this.getShortVersion();
        if (StringUtils.isEmpty(version)) {
            return name;
        }
        return String.format("%s %s %s", OSUtils.getShortName(), name, version);
    }
}

