/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public final class LogUtils {
    public static Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    public static void reset() {
        LogManager.getLogManager().reset();
    }

    public static void removeAllHandlers(Logger log) {
        Handler[] handlers;
        Handler[] handlerArray = handlers = log.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            log.removeHandler(handler);
            handler.flush();
            handler.close();
            ++n2;
        }
    }

    public static void addConsoleHandler(Logger log, Level level) {
        try {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(level);
            handler.setFormatter(new SimpleFormatter());
            log.addHandler(handler);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public static void addFileHandler(Logger log, Level level, String filename, int limit, int count) {
        try {
            FileHandler handler = new FileHandler(filename, limit, count, true);
            handler.setLevel(level);
            handler.setFormatter(new SimpleFormatter());
            log.addHandler(handler);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

