/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.IOUtils;
import org.bacza.utils.StringUtils;

public class FileUtils {
    public static final char[] INVALID_CHARACTERS;
    private static final int DEFAULT_BUFSIZE = 0x100000;

    static {
        char[] cArray = new char[15];
        cArray[0] = 92;
        cArray[1] = 47;
        cArray[2] = 13;
        cArray[3] = 10;
        cArray[4] = 9;
        cArray[5] = 12;
        cArray[7] = 96;
        cArray[8] = 63;
        cArray[9] = 42;
        cArray[10] = 60;
        cArray[11] = 62;
        cArray[12] = 124;
        cArray[13] = 34;
        cArray[14] = 58;
        INVALID_CHARACTERS = cArray;
    }

    public static String readAsString(InputStream is) throws IOException {
        return FileUtils.readAsString(is, "UTF-8");
    }

    public static byte[] readAsBytes(InputStream is) throws IOException {
        AssertUtils.notNull(is, "Input Stream");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        FileUtils.copyStream(is, os);
        return os.toByteArray();
    }

    public static String readAsString(InputStream is, String charsetName) throws IOException {
        if (is != null && StringUtils.notEmpty(charsetName)) {
            StringBuilder out = new StringBuilder(0x100000);
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(is, charsetName);
                if (reader != null) {
                    int n;
                    char[] buffer = new char[65536];
                    while ((n = ((Reader)reader).read(buffer, 0, buffer.length)) >= 0) {
                        out.append(buffer, 0, n);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(reader);
                throw throwable;
            }
            IOUtils.close(reader);
            return out.toString();
        }
        return null;
    }

    public static byte[] readFileAsBytes(String filename) throws IOException {
        AssertUtils.notNull(filename, "File Name");
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream is = new FileInputStream(new File(filename));){
            return FileUtils.readAsBytes(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readFileAsString(String filename) throws IOException {
        return FileUtils.readFileAsString(filename, "UTF-8");
    }

    public static String readFileAsString(String filename, String charsetName) throws IOException {
        AssertUtils.notNull(filename, "File Name");
        AssertUtils.notNull(charsetName, "Charset Name");
        return FileUtils.readAsString(new FileInputStream(new File(filename)), charsetName);
    }

    public static String readFileAsString(URI fileuri) throws IOException {
        return FileUtils.readFileAsString(fileuri, "UTF-8");
    }

    public static String readFileAsString(URI fileuri, String charsetName) throws IOException {
        AssertUtils.notNull(fileuri, "File URI");
        AssertUtils.notNull(charsetName, "Charset Name");
        return FileUtils.readAsString(new FileInputStream(new File(fileuri)), charsetName);
    }

    public static List<String> readFileAsStrings(String filename) throws IOException {
        AssertUtils.notNull(filename, "File Name");
        LinkedList<String> result = new LinkedList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            String line = reader.readLine();
            while (line != null) {
                result.add(line);
                line = reader.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public static byte[] readResourceAsBytes(Class<?> clazz, String path) throws IOException {
        AssertUtils.notNull(clazz, "Class");
        AssertUtils.notNull(path, "Path");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = clazz.getResourceAsStream(path);){
            if (is == null) {
                throw new IOException("Resource not found: " + path);
            }
            return FileUtils.readAsBytes(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readResourceAsString(Class<?> clazz, String path) throws IOException {
        return FileUtils.readResourceAsString(clazz, path, "UTF-8");
    }

    public static String readResourceAsString(Class<?> clazz, String path, String charsetName) throws IOException {
        AssertUtils.notNull(clazz, "Class");
        AssertUtils.notNull(path, "Path");
        AssertUtils.notNull(charsetName, "Charset Name");
        return FileUtils.readAsString(clazz.getResourceAsStream(path), charsetName);
    }

    public static void writeFile(String filename, byte[] data) throws IOException {
        AssertUtils.notNull(filename, "File Name");
        AssertUtils.notNull(data, "Data");
        File file = new File(filename);
        FileUtils.mkdirs(file.getParentFile());
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream os = new FileOutputStream(filename);){
            ((OutputStream)os).write(data);
            os.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeFile(String filename, String data) throws IOException {
        if (StringUtils.notEmpty(filename) && StringUtils.notEmpty(data)) {
            OutputStream os = null;
            OutputStreamWriter osw = null;
            try {
                File file = new File(filename);
                FileUtils.mkdirs(file.getParentFile());
                os = new FileOutputStream(filename);
                osw = new OutputStreamWriter(os, "UTF-8");
                osw.write(data);
            }
            finally {
                if (osw != null) {
                    osw.close();
                } else if (os != null) {
                    os.close();
                }
            }
        }
    }

    public static void writeFile(String filename, InputStream inputStream) throws IOException {
        if (StringUtils.notEmpty(filename) && inputStream != null) {
            try (OutputStream os = null;){
                File file = new File(filename);
                FileUtils.mkdirs(file.getParentFile());
                os = new FileOutputStream(filename);
                FileUtils.copyStream(inputStream, os);
            }
        }
    }

    public static boolean mkdirs(String path) {
        if (path != null) {
            return FileUtils.mkdirs(new File(path));
        }
        return false;
    }

    public static boolean mkdirs(File path) {
        if (path != null) {
            return path.mkdirs();
        }
        return false;
    }

    public static void rmdir(String path) throws IOException {
        AssertUtils.notEmpty(path, "Path");
        Path directory = Paths.get(path, new String[0]);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String combinePath(String path, String dir) {
        return new File(path, dir).getPath();
    }

    public static int copyStream(InputStream input, OutputStream output) throws IOException {
        int bytes = 0;
        if (input != null && output != null) {
            int n;
            byte[] buffer = new byte[8192];
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
                bytes += n;
            }
        }
        return bytes;
    }

    public static boolean fileExists(String filename) {
        boolean result = false;
        if (StringUtils.notEmpty(filename)) {
            File file = new File(filename);
            result = file.exists();
        }
        return result;
    }

    public static boolean dirExists(String path) {
        boolean result = false;
        if (StringUtils.notEmpty(path)) {
            File file = new File(path);
            result = file.isDirectory();
        }
        return result;
    }

    public static boolean createFile(String filename) throws IOException {
        boolean result = false;
        if (StringUtils.notEmpty(filename)) {
            File file = new File(filename);
            FileUtils.mkdirs(file.getParentFile());
            if (!file.exists()) {
                result = file.createNewFile();
            }
        }
        return result;
    }

    public static boolean deleteFile(String filename) {
        if (StringUtils.notEmpty(filename)) {
            File file = new File(filename);
            return file.delete();
        }
        return false;
    }

    public static boolean createPath(String path) throws IOException {
        return FileUtils.createPath(path, false);
    }

    public static boolean createPath(String path, boolean includesFilename) throws IOException {
        boolean result = false;
        if (StringUtils.notEmpty(path)) {
            File file = new File(path);
            result = FileUtils.mkdirs(includesFilename ? file.getParentFile() : file);
        }
        return result;
    }

    public static File[] getFiles(String path) {
        return FileUtils.getFiles(path, null);
    }

    public static File[] getFiles(String path, String filemask) {
        File dir;
        if (StringUtils.notEmpty(path) && (dir = new File(path)).isDirectory()) {
            if (filemask != null && (filemask = FileUtils.filemaskToRegex(StringUtils.toLowerCase(filemask))) == null) {
                throw new IllegalArgumentException("Invalid filemask.");
            }
            final String regex = filemask;
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isFile()) {
                        if (regex != null) {
                            return StringUtils.toLowerCase(pathname.getName()).matches(regex);
                        }
                        return true;
                    }
                    return false;
                }
            };
            return dir.listFiles(filter);
        }
        return null;
    }

    public static String filemaskToRegex(String filemask) {
        if (filemask != null) {
            filemask = filemask.replaceAll("\\\\", Matcher.quoteReplacement("\\\\"));
            filemask = filemask.replaceAll("\\.", Matcher.quoteReplacement("\\."));
            filemask = filemask.replaceAll("\\*", Matcher.quoteReplacement(".*"));
            filemask = filemask.replaceAll("\\?", Matcher.quoteReplacement("."));
            return filemask;
        }
        return null;
    }

    public static String getFilename(String path) {
        if (StringUtils.notEmpty(path)) {
            path = path.substring(path.lastIndexOf("/") + 1);
            path = path.substring(path.lastIndexOf("\\") + 1);
        }
        return path;
    }

    public static boolean isFilenameValid(String filename) {
        if (filename == null) {
            return false;
        }
        if (filename.isEmpty()) {
            return false;
        }
        if (!filename.equals(filename.trim())) {
            return false;
        }
        if (filename.equals(".") || filename.equals("..")) {
            return false;
        }
        if (filename.endsWith(".")) {
            return false;
        }
        char[] cArray = INVALID_CHARACTERS;
        int n = INVALID_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (filename.indexOf(c) >= 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

