/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.utils;

import org.bacza.utils.StringUtils;

public final class AssertUtils {
    public static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object argument) {
        AssertUtils.notNull(argument, null);
    }

    public static void notNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(String.valueOf(name == null ? "Argument" : name) + " may not be null.");
        }
    }

    public static void notEmpty(String argument) {
        AssertUtils.notEmpty(argument, null);
    }

    public static void notEmpty(String argument, String name) {
        if (StringUtils.isEmpty(argument)) {
            throw new IllegalArgumentException(String.valueOf(name == null ? "Argument" : name) + " may not be null or empty.");
        }
    }

    public static void fixme() {
        throw new IllegalStateException("FIXME!");
    }

    public static void fixme(String message) {
        throw new IllegalStateException(message);
    }
}

