/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.bacza.events.ListenerList;
import org.bacza.http.WebClient;
import org.bacza.http.WebSocketEventListener;
import org.bacza.http.WebSocketStatusListener;
import org.bacza.utils.AssertUtils;

public class WebSocket
implements Closeable {
    private final Map<String, InternalListener> internalListeners;
    private final ListenerList<WebSocketStatusListener> statusListeners;
    private final Socket socket;
    private boolean connected;

    public WebSocket(WebClient client, URI uri) {
        this(client, uri, null);
    }

    public WebSocket(WebClient client, URI uri, String bindPath) {
        AssertUtils.notNull(client, "WebClient");
        AssertUtils.notNull(uri, "URI");
        this.internalListeners = new HashMap<String, InternalListener>();
        this.statusListeners = new ListenerList();
        IO.Options opts = new IO.Options();
        opts.webSocketFactory = client.getHttpClient();
        opts.callFactory = client.getHttpClient();
        opts.reconnectionDelay = 1000L;
        opts.reconnectionDelayMax = 30000L;
        if (bindPath != null) {
            opts.path = bindPath;
        }
        this.socket = IO.socket((URI)uri, (IO.Options)opts);
        this.connected = false;
        this.addInternalListener("connect");
        this.addInternalListener("connecting");
        this.addInternalListener("disconnect");
        this.addInternalListener("error");
        this.addInternalListener("message");
        this.addInternalListener("reconnect");
        this.addInternalListener("reconnecting");
        this.addInternalListener("connect_error");
        this.addInternalListener("connect_timeout");
    }

    private InternalListener addInternalListener(String event) {
        InternalListener listener = this.internalListeners.get(event);
        if (listener == null) {
            listener = new InternalListener(event);
            this.internalListeners.put(event, listener);
            this.socket.on(event, (Emitter.Listener)listener);
        }
        return listener;
    }

    private InternalListener getInternalListener(String event) {
        return this.internalListeners.get(event);
    }

    private synchronized void event(String event, Object ... args) {
        boolean connected = this.socket.connected();
        boolean changed = false;
        if (this.connected != connected) {
            changed = true;
            this.connected = connected;
            this.notifyAll();
        }
        if (changed) {
            this.notifyStatusListeners(connected);
        }
    }

    public synchronized void open() {
        this.socket.open();
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized boolean waitForConnection() {
        return this.waitForConnection(0L);
    }

    public synchronized boolean waitForConnection(long msec) {
        while (!this.connected) {
            try {
                this.wait(msec);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return this.connected;
    }

    public void send(String event, Object ... args) {
        this.socket.emit(event, args);
    }

    @Override
    public synchronized void close() throws IOException {
        this.socket.off();
        this.socket.close();
    }

    public synchronized void addStatusListener(WebSocketStatusListener listener) {
        AssertUtils.notNull(listener, "Listener");
        this.statusListeners.addListener(listener);
    }

    public synchronized void removeStatusListener(WebSocketStatusListener listener) {
        AssertUtils.notNull(listener, "Listener");
        this.statusListeners.removeListener(listener);
    }

    public synchronized void addEventListener(String event, WebSocketEventListener listener) {
        AssertUtils.notEmpty(event, "Event");
        AssertUtils.notNull(listener, "Listener");
        InternalListener internalListener = this.addInternalListener(event);
        internalListener.userListeners.addListener(listener);
    }

    public synchronized void removeEventListener(String event, WebSocketEventListener listener) {
        AssertUtils.notEmpty(event, "Event");
        AssertUtils.notNull(listener, "Listener");
        InternalListener internalListener = this.getInternalListener(event);
        if (internalListener != null) {
            internalListener.userListeners.removeListener(listener);
        }
    }

    private void notifyStatusListeners(boolean connected) {
        for (WebSocketStatusListener l : this.statusListeners.getListeners()) {
            if (connected) {
                l.connected();
                continue;
            }
            l.disconnected();
        }
    }

    private class InternalListener
    implements Emitter.Listener {
        private final String event;
        private final ListenerList<WebSocketEventListener> userListeners;

        public InternalListener(String event) {
            this.event = event;
            this.userListeners = new ListenerList();
        }

        public void call(Object ... args) {
            WebSocket.this.event(this.event, args);
            for (WebSocketEventListener l : this.userListeners.getListeners()) {
                l.event(this.event, args);
            }
        }
    }
}

